/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.classfile;

import com.togethersoft.sca.internal.jparser.classfile.ClassConstant;
import com.togethersoft.sca.internal.jparser.classfile.Constant;
import com.togethersoft.sca.internal.jparser.classfile.DoubleConstant;
import com.togethersoft.sca.internal.jparser.classfile.FloatConstant;
import com.togethersoft.sca.internal.jparser.classfile.IntConstant;
import com.togethersoft.sca.internal.jparser.classfile.LongConstant;
import com.togethersoft.sca.internal.jparser.classfile.NameAndTypeConstant;
import com.togethersoft.sca.internal.jparser.classfile.RefConstant;
import com.togethersoft.sca.internal.jparser.classfile.StringConstant;
import com.togethersoft.sca.internal.jparser.classfile.Utf8Constant;
import java.io.DataInput;
import java.io.IOException;

class ConstantPool {
    private Constant[] pool;

    ConstantPool(DataInput fp) throws IOException {
        int poolCount = fp.readUnsignedShort();
        this.pool = new Constant[poolCount];
        int i = 1;
        while (i < poolCount) {
            Constant cp = null;
            boolean extra_item = false;
            int tag = fp.readUnsignedByte();
            switch (tag) {
                case 1: {
                    cp = new Utf8Constant(fp);
                    break;
                }
                case 3: {
                    cp = new IntConstant(fp);
                    break;
                }
                case 4: {
                    cp = new FloatConstant(fp);
                    break;
                }
                case 5: {
                    cp = new LongConstant(fp);
                    extra_item = true;
                    break;
                }
                case 6: {
                    cp = new DoubleConstant(fp);
                    extra_item = true;
                    break;
                }
                case 7: {
                    cp = new ClassConstant(fp);
                    break;
                }
                case 8: {
                    cp = new StringConstant(fp);
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    cp = new RefConstant(fp, tag);
                    break;
                }
                case 12: {
                    cp = new NameAndTypeConstant(fp);
                    break;
                }
                default: {
                    throw new IOException();
                }
            }
            this.pool[i] = cp;
            if (extra_item) {
                this.pool[++i] = cp;
            }
            ++i;
        }
    }

    Constant getConstant(int index) {
        if (this.checkIndex(index)) {
            return this.pool[index];
        }
        return null;
    }

    String getUtf8(int index) throws Exception {
        if (!this.checkIndex(index) || this.pool[index].getConstantType() != 1) {
            throw new IndexOutOfBoundsException("Invalid index in ConstantPool.getUtf8");
        }
        return ((Utf8Constant)this.pool[index]).toString();
    }

    String getClass(int index) throws Exception {
        if (!this.checkIndex(index) || this.pool[index].getConstantType() != 7) {
            throw new IndexOutOfBoundsException("Invalid index in ConstantPool.getClass");
        }
        ClassConstant clazz = (ClassConstant)this.pool[index];
        return this.getUtf8(clazz.getCls());
    }

    NameAndTypeConstant getNameAndType(int index) throws Exception {
        if (!this.checkIndex(index) || this.pool[index].getConstantType() != 12) {
            throw new IndexOutOfBoundsException("Invalid index in ConstantPool.getNameAndType");
        }
        return (NameAndTypeConstant)this.pool[index];
    }

    RefConstant getFieldRef(int index) throws Exception {
        if (!this.checkIndex(index) || this.pool[index].getConstantType() != 9) {
            throw new IndexOutOfBoundsException("Invalid index in ConstantPool.getFieldRef");
        }
        return (RefConstant)this.pool[index];
    }

    RefConstant getMethodRef(int index) throws Exception {
        if (!this.checkIndex(index) || this.pool[index].getConstantType() != 10 && this.pool[index].getConstantType() != 11) {
            throw new IndexOutOfBoundsException("Invalid index in ConstantPool.getRef");
        }
        return (RefConstant)this.pool[index];
    }

    private boolean checkIndex(int index) {
        return index >= 1 || index < this.pool.length;
    }
}

