/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.classfile;

import com.togethersoft.sca.internal.jparser.classfile.ClassDesc;
import com.togethersoft.sca.internal.jparser.classfile.ClassDescription;
import com.togethersoft.sca.internal.jparser.classfile.ClassDirectory;
import com.togethersoft.sca.internal.jparser.classfile.Data;
import com.togethersoft.sca.internal.jparser.classfile.DirClassDirectory;
import com.togethersoft.sca.internal.jparser.classfile.ZipClassDirectory;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ClassPath {
    private Hashtable allLoadedFile = new Hashtable();
    private ClassDirectory[] dirs;
    private ClassDescription FILE_UNDEFINED = new ClassDescription(){

        public Data getData() {
            throw new RuntimeException("DUMMY");
        }

        public String getFilename() {
            return null;
        }
    };

    public ClassPath(String classPath) {
        if (classPath == null && (classPath = System.getProperty("java.class.path")) == null) {
            classPath = ".";
        }
        String version = System.getProperty("java.version");
        if (System.getProperty("sun.boot.class.path") != null) {
            classPath = classPath + File.pathSeparator + System.getProperty("sun.boot.class.path");
        } else if (version.startsWith("1.2") || version.startsWith("1.3")) {
            String home = System.getProperty("java.home");
            classPath = classPath + File.pathSeparator + home + File.separatorChar + "lib" + File.separatorChar + "rt.jar";
        }
        this.dirs = this.parseClassPath(classPath);
    }

    private ClassDirectory[] parseClassPath(String classPath) {
        Vector<ClassDirectory> dirs = new Vector<ClassDirectory>();
        int length = classPath.length();
        int start = 0;
        while (start < length) {
            int end = classPath.indexOf(File.pathSeparatorChar, start);
            if (end == -1) {
                end = length;
            }
            try {
                File file = new File(classPath.substring(start, end));
                if (file.isDirectory()) {
                    dirs.addElement(new DirClassDirectory(file));
                } else if (file.isFile() && (file.getName().endsWith(".zip") || file.getName().endsWith(".jar"))) {
                    try {
                        dirs.addElement(new ZipClassDirectory(new ZipFile(file)));
                    }
                    catch (ZipException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (SecurityException e) {
                // empty catch block
            }
            start = end + 1;
        }
        Object[] cd = new ClassDirectory[dirs.size()];
        dirs.copyInto(cd);
        return cd;
    }

    public boolean hasClassFile(String name) {
        Object o = this.allLoadedFile.get(name);
        if (o != null && o != this.FILE_UNDEFINED) {
            return true;
        }
        ClassDescription file = this.getClassFile(name);
        this.allLoadedFile.put(name, file != null ? file : this.FILE_UNDEFINED);
        return file != null;
    }

    public ClassDesc getClassDesc(String name) {
        if (!this.hasClassFile(name)) {
            return null;
        }
        ClassDescription clazz = (ClassDescription)this.allLoadedFile.get(name);
        this.allLoadedFile.remove(name);
        Data data = clazz.getData();
        try {
            ClassDesc cl = new ClassDesc(clazz.getFilename(), data.getDataInput());
            data.release();
            return cl;
        }
        catch (Exception e) {
            data.release();
            e.printStackTrace();
            return null;
        }
    }

    private ClassDescription getClassFile(String name) {
        int i = 0;
        while (i < this.dirs.length) {
            ClassDescription file = this.dirs[i].getClassFile(name);
            if (file != null) {
                return file;
            }
            ++i;
        }
        return null;
    }
}

