/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.classfile;

import com.togethersoft.sca.internal.jparser.classfile.AccessFlags;
import com.togethersoft.sca.internal.jparser.classfile.ClassConstants;
import com.togethersoft.sca.internal.jparser.classfile.ConstantPool;
import com.togethersoft.sca.internal.jparser.classfile.FieldDesc;
import com.togethersoft.sca.internal.jparser.classfile.InnerClassDesc;
import com.togethersoft.sca.internal.jparser.classfile.MemberDesc;
import com.togethersoft.sca.internal.jparser.classfile.MethodDesc;
import java.io.DataInput;
import java.io.IOException;
import java.io.PrintStream;

public class ClassDesc
extends MemberDesc
implements ClassConstants {
    private String filename;
    String sourceFile;
    String superClass;
    String[] superInterfaces;
    public FieldDesc[] fields;
    public MethodDesc[] methods;
    public InnerClassDesc[] innerClasses;

    ClassDesc(String filename, DataInput fp) throws Exception {
        this.filename = filename;
        int magic = fp.readInt();
        if (magic != -889275714) {
            throw new IOException("Invalid magic number in class file");
        }
        fp.readUnsignedShort();
        fp.readUnsignedShort();
        ConstantPool cp = new ConstantPool(fp);
        int access_flags = fp.readUnsignedShort();
        int this_class_name = fp.readUnsignedShort();
        int super_class_name = fp.readUnsignedShort();
        int numInterfaces = fp.readUnsignedShort();
        this.setAccess(new AccessFlags(access_flags));
        this.setName(cp.getClass(this_class_name));
        this.sourceFile = this.getName() + ".java";
        if (super_class_name == 0) {
            if (numInterfaces != 0) {
                throw new Exception("java.lang.Object class implements " + numInterfaces + " interfaces");
            }
            this.superClass = null;
            this.superInterfaces = null;
        } else {
            this.superClass = cp.getClass(super_class_name);
            this.superInterfaces = new String[numInterfaces];
            int i = 0;
            while (i < numInterfaces) {
                int interface_name = fp.readUnsignedShort();
                this.superInterfaces[i] = cp.getClass(interface_name);
                ++i;
            }
        }
        int numFields = fp.readUnsignedShort();
        this.fields = new FieldDesc[numFields];
        int i = 0;
        while (i < numFields) {
            this.fields[i] = new FieldDesc(cp, fp);
            ++i;
        }
        int numMethods = fp.readUnsignedShort();
        this.methods = new MethodDesc[numMethods];
        int i2 = 0;
        while (i2 < numMethods) {
            this.methods[i2] = new MethodDesc(cp, fp);
            ++i2;
        }
        int attr_count = fp.readUnsignedShort();
        while (--attr_count >= 0) {
            int attr_index = fp.readUnsignedShort();
            int attr_length = fp.readInt();
            String attrName = cp.getUtf8(attr_index);
            if (attrName.equals("SourceFile")) {
                int sourceIdx = fp.readUnsignedShort();
                this.sourceFile = cp.getUtf8(sourceIdx);
                continue;
            }
            if (attrName.equals("InnerClasses")) {
                int numClasses = fp.readUnsignedShort();
                this.innerClasses = new InnerClassDesc[numClasses];
                int i3 = 0;
                while (i3 < numClasses) {
                    this.innerClasses[i3] = new InnerClassDesc(fp, cp, this);
                    ++i3;
                }
                continue;
            }
            if (attrName.equals("Deprecated")) {
                this.setDeprecated(true);
                continue;
            }
            fp.skipBytes(attr_length);
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public String getSuperClass() {
        return this.superClass;
    }

    public int numSuperInterfaces() {
        return this.superInterfaces == null ? 0 : this.superInterfaces.length;
    }

    public String getSuperInterface(int i) {
        return this.superInterfaces[i];
    }

    void print(PrintStream out) {
        int i;
        out.print(this.getAccess().toString() + this.getName());
        if (this.getAccess().isInterface()) {
            out.println(" (interface)");
        } else {
            out.println(" (class)");
        }
        out.println("[" + this.sourceFile + "]");
        if (this.getSuperClass() != null) {
            out.println("Extends " + this.getSuperClass());
        }
        if (this.numSuperInterfaces() > 0) {
            out.print("Implements ");
            i = 0;
            while (i < this.numSuperInterfaces()) {
                out.print(this.getSuperInterface(i));
                if (i < this.numSuperInterfaces() - 1) {
                    out.print(", ");
                }
                ++i;
            }
            out.println("");
        }
        if (this.fields.length > 0) {
            out.println("Fields:");
            i = 0;
            while (i < this.fields.length) {
                this.fields[i].print(out);
                ++i;
            }
        }
        if (this.methods.length > 0) {
            out.println("Methods:");
            i = 0;
            while (i < this.methods.length) {
                this.methods[i].print(out);
                ++i;
            }
        }
    }
}

