/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast.writer;

import com.togethersoft.sca.internal.jparser.ast.Ast;
import com.togethersoft.sca.internal.jparser.ast.Block;
import com.togethersoft.sca.internal.jparser.ast.Comment;
import com.togethersoft.sca.internal.jparser.ast.Declaration;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.Modifier;
import com.togethersoft.sca.internal.jparser.ast.Name;
import com.togethersoft.sca.internal.jparser.ast.Stmt;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

public class FormatWriter
extends PrintWriter {
    private int line = 1;
    private int column = 1;
    private int lineOffset = 0;
    private int lineAdjustment = 0;
    private int columnOffset = 0;
    private char prevChar;
    private int prevTokenType = 0;

    public void addLineAdjustment(int newAdjustment) {
        this.lineAdjustment += newAdjustment;
    }

    public FormatWriter(Writer out) {
        super(out);
    }

    public FormatWriter(Writer out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public FormatWriter(OutputStream out) {
        super(out);
    }

    public FormatWriter(OutputStream out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public void print(String s) {
        int i = 0;
        int n = s.length();
        while (i < n) {
            this.print(s.charAt(i));
            ++i;
        }
    }

    public void print(char ch) {
        this.prevChar = ch;
        if (ch == '\n') {
            super.println();
            ++this.line;
            this.column = 1;
            this.columnOffset = 0;
        } else if (ch != '\r') {
            super.print(ch);
            ++this.column;
        }
    }

    public void printName(Name name) {
        this.print(' ');
        this.print(name.getFullName().replace('/', '.'));
    }

    private static boolean separatorNeeded(char prev, char next) {
        return next != '(' && next != ')' && next != ']' && next != '.' && next != ';' && next != ',' && prev != '(' && prev != '[' && prev != '.';
    }

    public boolean isPrintable(Ast ast) {
        if (ast == null) {
            return false;
        }
        if (ast.isDeleted()) {
            if (ast instanceof Modifier) {
                this.printComments(ast.leftToken());
            }
            if (ast instanceof Stmt || ast instanceof Declaration) {
                this.lineOffset -= ast.getEndLine() - ast.getStartLineWithComments() + 1;
            } else {
                int startLine = ast.getStartLineWithComments() + this.lineAdjustment + this.lineOffset;
                while (this.line < startLine) {
                    this.print('\n');
                }
                this.lineOffset -= ast.getEndLine() - ast.getStartLineWithComments();
                this.columnOffset -= ast.getEndColumn() - ast.getStartColumnWithComments() + 1;
            }
            return false;
        }
        if (ast.getStartLine() == 0) {
            return true;
        }
        int startLine = ast.getStartLineWithComments() + this.lineAdjustment + this.lineOffset;
        int startColumn = ast.getStartColumnWithComments() + this.columnOffset;
        if (startLine < this.line) {
            this.lineOffset += this.line - startLine;
        } else if (startLine == this.line && startColumn < this.column && (ast instanceof Stmt && !(ast instanceof Block) || ast instanceof Comment)) {
            ++this.lineOffset;
            this.prevTokenType = 0;
            this.print('\n');
        }
        return true;
    }

    public void printComments(JavaToken tkn) {
        Comment[] comments;
        if (tkn != null && (comments = tkn.getComments()) != null) {
            int i = 0;
            while (i < comments.length) {
                if (this.isPrintable(comments[i])) {
                    this.print(comments[i].leftToken());
                }
                ++i;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void print(JavaToken tkn) {
        block11: {
            block12: {
                block10: {
                    if (tkn == null) {
                        return;
                    }
                    this.printComments(tkn);
                    startLine = tkn.getLine() + this.lineAdjustment + this.lineOffset;
                    while (this.line < startLine) {
                        this.prevTokenType = 0;
                        this.print('\n');
                    }
                    startColumn = tkn.getColumn() + this.columnOffset;
                    txt = tkn.getText();
                    if (this.prevTokenType != 44) break block10;
                    if (FormatWriter.separatorNeeded(this.prevChar, txt.charAt(0))) {
                        this.print(' ');
                    }
                    if (tkn.getType() != 44) {
                        this.columnOffset -= startColumn - this.column;
                    }
                    break block11;
                }
                if (startColumn >= this.column) ** GOTO lbl33
                if (tkn.getType() != 75) break block12;
                this.print('\n');
                startColumn = tkn.getColumn();
                while (this.column < startColumn) {
                    this.print(' ');
                }
                break block11;
            }
            this.columnOffset += startColumn - this.column;
            if (!FormatWriter.separatorNeeded(this.prevChar, txt.charAt(0))) break block11;
            ++this.columnOffset;
            this.print(' ');
            break block11;
lbl-1000:
            // 1 sources

            {
                this.print(' ');
lbl33:
                // 2 sources

                ** while (this.column < startColumn)
            }
        }
        this.prevTokenType = tkn.getType();
        this.print(txt);
    }
}

