/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast.writer;

import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.internal.jparser.ast.ArrayAccess;
import com.togethersoft.sca.internal.jparser.ast.ArrayCreationExpr;
import com.togethersoft.sca.internal.jparser.ast.ArrayInitializer;
import com.togethersoft.sca.internal.jparser.ast.AssertStmt;
import com.togethersoft.sca.internal.jparser.ast.AssignExpr;
import com.togethersoft.sca.internal.jparser.ast.Ast;
import com.togethersoft.sca.internal.jparser.ast.BinaryExpr;
import com.togethersoft.sca.internal.jparser.ast.BinaryNotExpr;
import com.togethersoft.sca.internal.jparser.ast.Block;
import com.togethersoft.sca.internal.jparser.ast.Brackets;
import com.togethersoft.sca.internal.jparser.ast.BreakStmt;
import com.togethersoft.sca.internal.jparser.ast.CaseLabel;
import com.togethersoft.sca.internal.jparser.ast.CastExpr;
import com.togethersoft.sca.internal.jparser.ast.CatchClause;
import com.togethersoft.sca.internal.jparser.ast.ClassInitializer;
import com.togethersoft.sca.internal.jparser.ast.CompilationUnit;
import com.togethersoft.sca.internal.jparser.ast.ConditionalExpr;
import com.togethersoft.sca.internal.jparser.ast.ContinueStmt;
import com.togethersoft.sca.internal.jparser.ast.Declaration;
import com.togethersoft.sca.internal.jparser.ast.DeclarationStmt;
import com.togethersoft.sca.internal.jparser.ast.DefaultLabel;
import com.togethersoft.sca.internal.jparser.ast.DoStmt;
import com.togethersoft.sca.internal.jparser.ast.EmptyStmt;
import com.togethersoft.sca.internal.jparser.ast.Expr;
import com.togethersoft.sca.internal.jparser.ast.ExprStmt;
import com.togethersoft.sca.internal.jparser.ast.FieldAccess;
import com.togethersoft.sca.internal.jparser.ast.FinallyClause;
import com.togethersoft.sca.internal.jparser.ast.ForStmt;
import com.togethersoft.sca.internal.jparser.ast.FormalParameter;
import com.togethersoft.sca.internal.jparser.ast.IfStmt;
import com.togethersoft.sca.internal.jparser.ast.ImportDeclaration;
import com.togethersoft.sca.internal.jparser.ast.IncDecExpr;
import com.togethersoft.sca.internal.jparser.ast.Literal;
import com.togethersoft.sca.internal.jparser.ast.LogicalNotExpr;
import com.togethersoft.sca.internal.jparser.ast.MethodCall;
import com.togethersoft.sca.internal.jparser.ast.MethodDeclaration;
import com.togethersoft.sca.internal.jparser.ast.Modifier;
import com.togethersoft.sca.internal.jparser.ast.NewExpr;
import com.togethersoft.sca.internal.jparser.ast.ParExpr;
import com.togethersoft.sca.internal.jparser.ast.ReturnStmt;
import com.togethersoft.sca.internal.jparser.ast.SimpleName;
import com.togethersoft.sca.internal.jparser.ast.Stmt;
import com.togethersoft.sca.internal.jparser.ast.SuperCall;
import com.togethersoft.sca.internal.jparser.ast.SuperExpr;
import com.togethersoft.sca.internal.jparser.ast.SwitchGroup;
import com.togethersoft.sca.internal.jparser.ast.SwitchStmt;
import com.togethersoft.sca.internal.jparser.ast.SynchronizedStmt;
import com.togethersoft.sca.internal.jparser.ast.ThisCall;
import com.togethersoft.sca.internal.jparser.ast.ThisExpr;
import com.togethersoft.sca.internal.jparser.ast.ThrowStmt;
import com.togethersoft.sca.internal.jparser.ast.TryStmt;
import com.togethersoft.sca.internal.jparser.ast.TypeDeclaration;
import com.togethersoft.sca.internal.jparser.ast.TypeExpr;
import com.togethersoft.sca.internal.jparser.ast.UnaryPlusMinusExpr;
import com.togethersoft.sca.internal.jparser.ast.VariableDeclaration;
import com.togethersoft.sca.internal.jparser.ast.VariableDeclarator;
import com.togethersoft.sca.internal.jparser.ast.WhileStmt;
import com.togethersoft.sca.internal.jparser.ast.writer.FormatWriter;

public class AstWriter {
    private FormatWriter out;

    public void writeFile(FormatWriter out, CompilationUnit cu) {
        this.out = out;
        if (out.isPrintable(cu)) {
            if (cu.getPackageName() != null) {
                out.print(cu.packageToken);
                out.printName(cu.getPackageName());
                out.print(';');
            }
            int i = 0;
            while (i < cu.numImportDeclarations()) {
                ImportDeclaration imp = cu.getImportDeclaration(i);
                if (!imp.isDeleted()) {
                    out.print(imp.leftToken());
                    out.print(' ');
                    out.print(imp.getElementName().replace('/', '.'));
                    out.print(imp.isOnDemand() ? ".*;" : ";");
                }
                ++i;
            }
            AstType[] types = cu.getTypes();
            int i2 = 0;
            while (i2 < types.length) {
                this.writeDecl((TypeDeclaration)types[i2]);
                ++i2;
            }
            out.print(cu.eofToken);
        }
    }

    private void writeType(TypeDeclaration type) {
        this.out.print(type.classToken);
        this.out.print(type.nameToken);
        if (type.isClass() && type.getSuperType() != null) {
            this.out.print(type.extendsToken);
            this.out.printName(type.getSuperType().getType());
        }
        int i = 0;
        int j = 0;
        while (i < type.numInterfaces()) {
            if (this.out.isPrintable(type.getInterface(i))) {
                if (j++ != 0) {
                    this.out.print(',');
                } else {
                    this.out.print(type.isClass() ? type.implementsToken : type.extendsToken);
                }
                this.out.printName(type.getInterface(i).getType());
            }
            ++i;
        }
        this.out.print(type.leftBrace);
        AstDeclaration[] members = type.getMembers();
        int i2 = 0;
        while (i2 < members.length) {
            Declaration decl = (Declaration)members[i2];
            if (this.writeDecl(decl) && decl.astType() == 28) {
                this.out.print(';');
            }
            ++i2;
        }
        this.out.print(type.rightBrace);
    }

    private boolean writeDecl(Declaration decl) {
        this.out.addLineAdjustment(decl.getLineAdjustment());
        boolean printed = false;
        if (this.out.isPrintable(decl)) {
            this.writeModifiers(decl);
            switch (decl.astType()) {
                case 26: {
                    this.writeType((TypeDeclaration)decl);
                    break;
                }
                case 15: {
                    this.writeMethod((MethodDeclaration)decl);
                    break;
                }
                case 60: {
                    this.writeClassInit((ClassInitializer)decl);
                    break;
                }
                case 11: {
                    this.writeParameter((FormalParameter)decl);
                    break;
                }
                case 28: {
                    this.writeVariable((VariableDeclaration)decl);
                }
            }
            printed = true;
        }
        this.out.addLineAdjustment(-decl.getLineAdjustment());
        return printed;
    }

    private void writeClassInit(ClassInitializer init) {
        this.writeStmt(init.getBlockBody());
    }

    private void writeVariable(VariableDeclaration decl) {
        this.writeTypeExpr(decl.typeSpec);
        int i = 0;
        int j = 0;
        while (i < decl.numDeclarators()) {
            if (this.out.isPrintable(decl.getDeclarator(i))) {
                if (j++ != 0) {
                    this.out.print(',');
                }
                this.writeVariableDeclarator(decl.getDeclarator(i));
            }
            ++i;
        }
    }

    private void writeVariableDeclarator(VariableDeclarator var) {
        this.out.print(var.leftToken());
        int i = 0;
        while (i < var.numBrackets()) {
            this.writeBrackets(var.brackets(i));
            ++i;
        }
        this.out.print(var.assignToken);
        this.writeExpr(var.initializer);
    }

    private void writeMethod(MethodDeclaration method) {
        if (method.retType != null) {
            this.writeTypeExpr(method.retType);
        }
        this.out.print(method.nameToken);
        this.out.print(method.leftParen);
        int i = 0;
        int j = 0;
        while (i < method.numFormalParameters()) {
            if (this.out.isPrintable(method.getFormalParameter(i))) {
                if (j++ != 0) {
                    this.out.print(',');
                }
                this.writeDecl(method.getFormalParameter(i));
            }
            ++i;
        }
        this.out.print(method.rightParen);
        int i2 = 0;
        while (i2 < method.numBrackets()) {
            this.writeBrackets(method.brackets(i2));
            ++i2;
        }
        int i3 = 0;
        int j2 = 0;
        while (i3 < method.numThrowSpecifiers()) {
            if (this.out.isPrintable(method.getThrowSpecifier(i3))) {
                if (j2++ == 0) {
                    this.out.print(method.throwsToken);
                } else {
                    this.out.print(',');
                }
                this.out.printName(method.getThrowSpecifier(i3).getThrowType());
            }
            ++i3;
        }
        this.writeStmt(method.body);
    }

    private void writeParameter(FormalParameter param) {
        this.writeExpr(param.typeSpec);
        this.writeVariableDeclarator(param.declarator);
    }

    private void writeModifiers(Declaration decl) {
        if (decl.modifiers == null) {
            return;
        }
        int i = 0;
        while (i < decl.modifiers.numModifiers()) {
            Modifier m = decl.modifiers.modifier(i);
            if (this.out.isPrintable(m)) {
                this.out.print(m.leftToken());
            }
            ++i;
        }
    }

    private void writeTypeExpr(TypeExpr typeExpr) {
        this.writeExpr(typeExpr.type);
        int i = 0;
        while (i < typeExpr.numBrackets()) {
            this.writeBrackets(typeExpr.brackets(i));
            ++i;
        }
    }

    private void writeBrackets(Brackets expr) {
        if (this.out.isPrintable(expr)) {
            this.out.print(expr.leftToken());
            this.writeExpr(expr.expr);
            this.out.print(expr.rightToken());
        }
    }

    private boolean writeStmt(Stmt stmt) {
        if (!this.out.isPrintable(stmt)) {
            return false;
        }
        int i = 0;
        while (i < stmt.numLabels()) {
            if (this.writeExpr(stmt.label(i))) {
                this.out.print(':');
            }
            ++i;
        }
        switch (stmt.astType()) {
            case 9: {
                this.writeExprStmt((ExprStmt)stmt);
                break;
            }
            case 3: {
                this.writeBlock((Block)stmt);
                break;
            }
            case 8: {
                this.writeEmptyStmt((EmptyStmt)stmt);
                break;
            }
            case 59: {
                this.writeDeclStmt((DeclarationStmt)stmt);
                break;
            }
            case 41: {
                this.writeIfStmt((IfStmt)stmt);
                break;
            }
            case 44: {
                this.writeForStmt((ForStmt)stmt);
                break;
            }
            case 43: {
                this.writeWhileStmt((WhileStmt)stmt);
                break;
            }
            case 42: {
                this.writeDoStmt((DoStmt)stmt);
                break;
            }
            case 53: {
                this.writeSwitchStmt((SwitchStmt)stmt);
                break;
            }
            case 51: {
                this.writeTryStmt((TryStmt)stmt);
                break;
            }
            case 55: {
                this.writeReturnStmt((ReturnStmt)stmt);
                break;
            }
            case 57: {
                this.writeBreakStmt((BreakStmt)stmt);
                break;
            }
            case 56: {
                this.writeContinueStmt((ContinueStmt)stmt);
                break;
            }
            case 62: {
                this.writeAssertStmt((AssertStmt)stmt);
                break;
            }
            case 52: {
                this.writeThrowStmt((ThrowStmt)stmt);
                break;
            }
            case 45: {
                this.writeSynchronizedStmt((SynchronizedStmt)stmt);
            }
        }
        return true;
    }

    private void writeSynchronizedStmt(SynchronizedStmt stmt) {
        this.out.print(stmt.syncToken);
        this.writeExpr(stmt.condition());
        this.writeStmt(stmt.body());
    }

    private void writeDoStmt(DoStmt stmt) {
        this.out.print(stmt.doToken);
        this.writeStmt(stmt.body());
        this.out.print(stmt.whileToken);
        this.writeExpr(stmt.condition());
        this.out.print(stmt.semiToken);
    }

    private void writeThrowStmt(ThrowStmt stmt) {
        this.out.print(stmt.leftToken());
        this.writeExpr(stmt.expr());
        this.out.print(stmt.rightToken());
    }

    private void writeAssertStmt(AssertStmt stmt) {
        this.out.print(stmt.leftToken());
        this.writeExpr(stmt.condition());
        this.out.print(stmt.colonToken);
        this.writeExpr(stmt.argument());
        this.out.print(stmt.rightToken());
    }

    private void writeBreakStmt(BreakStmt stmt) {
        this.out.print(stmt.leftToken());
        this.out.print(stmt.rightToken());
    }

    private void writeContinueStmt(ContinueStmt stmt) {
        this.out.print(stmt.leftToken());
        this.writeExpr(stmt.label());
        this.out.print(stmt.rightToken());
    }

    private void writeSwitchStmt(SwitchStmt stmt) {
        this.out.print(stmt.leftToken());
        this.writeExpr(stmt.condition());
        this.out.print(stmt.leftBrace);
        int i = 0;
        while (i < stmt.numSwitchGroups()) {
            this.writeSwitchGroup(stmt.getSwitchGroup(i));
            ++i;
        }
        this.out.print(stmt.rightBrace);
    }

    private void writeSwitchGroup(SwitchGroup group) {
        int i = 0;
        while (i < group.numCaseLabels()) {
            this.writeCaseLabel(group.getCaseLabel(i));
            ++i;
        }
        int i2 = 0;
        while (i2 < group.numStatements()) {
            this.writeStmt(group.getStatement(i2));
            ++i2;
        }
    }

    private void writeCaseLabel(Ast label) {
        if (label.astType() == 50) {
            CaseLabel cl = (CaseLabel)label;
            this.out.print(cl.leftToken());
            this.writeExpr(cl.expr());
            this.out.print(cl.rightToken());
        } else {
            DefaultLabel dl = (DefaultLabel)label;
            this.out.print(dl.leftToken());
            this.out.print(dl.rightToken());
        }
    }

    private void writeReturnStmt(ReturnStmt stmt) {
        this.out.print(stmt.leftToken());
        this.writeExpr(stmt.expr());
        this.out.print(stmt.rightToken());
    }

    private void writeTryStmt(TryStmt stmt) {
        this.out.print(stmt.leftToken());
        this.writeBlock(stmt.body());
        int i = 0;
        while (i < stmt.numCatchClauses()) {
            this.writeCatchClause(stmt.catchClause(i));
            ++i;
        }
        if (stmt.finallyClause() != null) {
            this.writeFinallyClause(stmt.finallyClause());
        }
    }

    private void writeCatchClause(CatchClause clause) {
        this.out.print(clause.leftToken());
        this.out.print(clause.leftParen);
        this.writeDecl(clause.param());
        this.out.print(clause.rightParen);
        this.writeBlock(clause.body());
    }

    private void writeFinallyClause(FinallyClause clause) {
        this.out.print(clause.leftToken());
        this.writeBlock(clause.body());
    }

    private void writeWhileStmt(WhileStmt stmt) {
        this.out.print(stmt.leftToken());
        this.writeExpr(stmt.condition());
        this.writeStmt(stmt.body());
    }

    private void writeForStmt(ForStmt stmt) {
        this.out.print(stmt.leftToken());
        this.out.print(stmt.leftParen);
        int i = 0;
        while (i < stmt.numInitStatements()) {
            if (i > 0) {
                this.out.print(',');
            }
            this.writeStmt(stmt.initStatement(i));
            ++i;
        }
        this.out.print(';');
        this.writeExpr(stmt.condition());
        this.out.print(';');
        int i2 = 0;
        while (i2 < stmt.numUpdateStatements()) {
            if (i2 > 0) {
                this.out.print(',');
            }
            this.writeStmt(stmt.updateStatement(i2));
            ++i2;
        }
        this.out.print(stmt.rightParen);
        this.writeStmt(stmt.body());
    }

    private void writeIfStmt(IfStmt stmt) {
        this.out.print(stmt.leftToken());
        this.writeExpr(stmt.condition());
        this.writeStmt(stmt.thenStmt());
        this.out.print(stmt.elseToken);
        this.writeStmt(stmt.elseStmt());
    }

    private void writeDeclStmt(DeclarationStmt stmt) {
        this.writeDecl(stmt.decl());
        if (stmt.semicolon != null) {
            this.out.print(stmt.semicolon);
        }
    }

    private void writeEmptyStmt(EmptyStmt stmt) {
        this.out.print(stmt.leftToken());
    }

    private void writeBlock(Block stmt) {
        this.out.print(stmt.leftToken());
        int i = 0;
        while (i < stmt.numStatements()) {
            this.writeStmt(stmt.statement(i));
            ++i;
        }
        this.out.print(stmt.rightToken());
    }

    private void writeExprStmt(ExprStmt stmt) {
        this.writeExpr(stmt.expr());
        this.out.print(stmt.semicolon);
    }

    private boolean writeExpr(Expr expr) {
        if (!this.out.isPrintable(expr)) {
            return false;
        }
        switch (expr.astType()) {
            case 1: {
                this.writeAsgnExpr((AssignExpr)expr);
                break;
            }
            case 22: {
                this.writeSimpleName((SimpleName)expr);
                break;
            }
            case 10: {
                this.writeFieldAccess((FieldAccess)expr);
                break;
            }
            case 25: {
                this.writeThisExpr((ThisExpr)expr);
                break;
            }
            case 24: {
                this.writeSuperExpr((SuperExpr)expr);
                break;
            }
            case 58: {
                this.writeThisCall((ThisCall)expr);
                break;
            }
            case 30: {
                this.writeSuperCall((SuperCall)expr);
                break;
            }
            case 14: {
                this.writeLiteral((Literal)expr);
                break;
            }
            case 2: {
                this.writeBinaryExpr((BinaryExpr)expr);
                break;
            }
            case 31: {
                this.writeUnaryPlusMinusExpr((UnaryPlusMinusExpr)expr);
                break;
            }
            case 46: {
                this.writeParExpr((ParExpr)expr);
                break;
            }
            case 16: {
                this.writeMethodCall((MethodCall)expr);
                break;
            }
            case 20: {
                this.writeNewExpr((NewExpr)expr);
                break;
            }
            case 39: {
                this.writeArrayCreationExpr((ArrayCreationExpr)expr);
                break;
            }
            case 38: {
                this.writeArrayInitializer((ArrayInitializer)expr);
                break;
            }
            case 36: {
                this.writeArrayAccess((ArrayAccess)expr);
                break;
            }
            case 4: {
                this.writeCastExpr((CastExpr)expr);
                break;
            }
            case 27: {
                this.writeTypeExpr((TypeExpr)expr);
                break;
            }
            case 35: {
                this.writeLogicalNotExpr((LogicalNotExpr)expr);
                break;
            }
            case 34: {
                this.writeBinaryNotExpr((BinaryNotExpr)expr);
                break;
            }
            case 32: {
                this.writeIncDecExpr((IncDecExpr)expr);
                break;
            }
            case 7: {
                this.writeConditionalExpr((ConditionalExpr)expr);
            }
        }
        return true;
    }

    private void writeBinaryNotExpr(BinaryNotExpr expr) {
        this.out.print(expr.opToken);
        this.writeExpr(expr.expr());
    }

    private void writeThisCall(ThisCall call) {
        this.writeExpr(call.thisKeyword);
        this.out.print(call.leftParen);
        int i = 0;
        while (i < call.numArguments()) {
            if (i > 0) {
                this.out.print(',');
            }
            this.writeExpr(call.argument(i));
            ++i;
        }
        this.out.print(call.rightParen);
    }

    private void writeSuperCall(SuperCall call) {
        this.writeExpr(call.base());
        this.out.print(call.dotToken);
        this.writeExpr(call.superKeyword);
        this.out.print(call.leftParen);
        int i = 0;
        while (i < call.numArguments()) {
            if (i > 0) {
                this.out.print(',');
            }
            this.writeExpr(call.argument(i));
            ++i;
        }
        this.out.print(call.rightParen);
    }

    private void writeArrayCreationExpr(ArrayCreationExpr expr) {
        this.out.print(expr.leftToken());
        this.out.printName(expr.arrayType);
        int i = 0;
        while (i < expr.numDimensions()) {
            this.writeBrackets(expr.dimension(i));
            ++i;
        }
        this.writeExpr(expr.initializer);
    }

    private void writeSuperExpr(SuperExpr expr) {
        this.out.print(expr.leftToken());
    }

    private void writeThisExpr(ThisExpr expr) {
        this.out.print(expr.leftToken());
    }

    private void writeConditionalExpr(ConditionalExpr expr) {
        this.writeExpr(expr.testExpr());
        this.out.print(expr.questionToken);
        this.writeExpr(expr.trueExpr());
        this.out.print(expr.colonToken);
        this.writeExpr(expr.falseExpr());
    }

    private void writeIncDecExpr(IncDecExpr expr) {
        if (expr.getExpressionKind() == 4 || expr.getExpressionKind() == 5) {
            this.out.print(expr.leftToken());
            this.writeExpr(expr.expr());
        } else {
            this.writeExpr(expr.expr());
            this.out.print(expr.rightToken());
        }
    }

    private void writeLogicalNotExpr(LogicalNotExpr expr) {
        this.out.print(expr.leftToken());
        this.writeExpr(expr.expr());
    }

    private void writeArrayInitializer(ArrayInitializer init) {
        this.out.print(init.leftBrace);
        int i = 0;
        while (i < init.numInitializers()) {
            if (i > 0) {
                this.out.print(',');
            }
            this.writeExpr(init.getInitializer(i));
            ++i;
        }
        this.out.print(init.rightBrace);
    }

    private void writeCastExpr(CastExpr expr) {
        this.out.print(expr.leftParen);
        this.writeExpr(expr.typeSpec);
        this.out.print(expr.rightParen);
        this.writeExpr(expr.expression);
    }

    private void writeArrayAccess(ArrayAccess expr) {
        this.writeExpr(expr.base);
        this.out.print(expr.leftBracket);
        this.writeExpr(expr.index);
        this.out.print(expr.rightBracket);
    }

    private void writeParExpr(ParExpr expr) {
        this.out.print(expr.leftToken());
        this.writeExpr(expr.expr());
        this.out.print(expr.rightToken());
    }

    private void writeNewExpr(NewExpr expr) {
        this.writeExpr(expr.base);
        this.out.print(expr.newToken);
        this.writeExpr(expr.typeSpec);
        this.out.print(expr.leftParen);
        int i = 0;
        while (i < expr.numArguments()) {
            if (i > 0) {
                this.out.print(',');
            }
            this.writeExpr(expr.argument(i));
            ++i;
        }
        this.out.print(expr.rightParen);
        if (expr.classBody != null) {
            this.writeType(expr.classBody);
        }
    }

    private void writeUnaryPlusMinusExpr(UnaryPlusMinusExpr expr) {
        this.out.print(expr.leftToken());
        this.writeExpr(expr.expression);
    }

    private void writeMethodCall(MethodCall expr) {
        this.writeExpr(expr.method);
        this.out.print(expr.leftParen);
        int i = 0;
        while (i < expr.numArguments()) {
            if (i > 0) {
                this.out.print(',');
            }
            this.writeExpr(expr.argument(i));
            ++i;
        }
        this.out.print(expr.rightParen);
    }

    private void writeBinaryExpr(BinaryExpr expr) {
        this.writeExpr(expr.leftExpr());
        this.out.print(expr.opToken);
        this.writeExpr(expr.rightExpr());
    }

    private void writeFieldAccess(FieldAccess expr) {
        this.writeExpr(expr.base());
        this.out.print(expr.dotToken);
        this.out.print(expr.rightToken());
    }

    private void writeLiteral(Literal expr) {
        this.out.print(expr.rightToken());
    }

    private void writeSimpleName(SimpleName expr) {
        this.out.print(expr.rightToken());
    }

    private void writeAsgnExpr(AssignExpr expr) {
        this.writeExpr(expr.leftExpr());
        this.out.print(expr.opToken);
        this.writeExpr(expr.rightExpr());
    }
}

