/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstStatement;
import com.togethersoft.sca.ast.AstWhileStatement;
import com.togethersoft.sca.internal.jparser.ast.Expr;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.ParExpr;
import com.togethersoft.sca.internal.jparser.ast.Stmt;
import com.togethersoft.sca.internal.jparser.ast.Visitor;

public class WhileStmt
extends Stmt
implements AstWhileStatement {
    private JavaToken whileToken;
    private ParExpr condition;
    private Stmt body;

    public WhileStmt(JavaToken whileToken, ParExpr condition, Stmt body) {
        this.whileToken = whileToken;
        this.condition = condition;
        this.body = body;
        condition.setParent(this);
        body.setParent(this);
    }

    public int astType() {
        return 43;
    }

    public int getObjectKind() {
        return 10;
    }

    public AstObject[] getChildren() {
        return new AstObject[]{this.body, this.condition.expr()};
    }

    public AstStatement getBody() {
        return this.body;
    }

    public AstExpression getCondition() {
        return this.condition.expr();
    }

    public Expr condition() {
        return this.condition;
    }

    public Stmt body() {
        return this.body;
    }

    public void accept(Visitor visitor) {
        if (visitor.stmtVisitor != null) {
            visitor.stmtVisitor.visitWhileStatement(this);
        } else {
            visitor.visitWhileStmt(this);
        }
    }

    public void traverse(Visitor visitor) {
        this.condition.action(visitor);
        this.body.action(visitor);
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        if (this.condition == oldObj) {
            this.condition = (ParExpr)newObj;
        } else if (this.body == oldObj) {
            this.body = (Stmt)newObj;
        } else {
            return false;
        }
        return true;
    }

    public JavaToken leftToken() {
        return this.whileToken;
    }

    public JavaToken rightToken() {
        return this.body.rightToken();
    }
}

