/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.internal.jparser.ast.ArrayAccess;
import com.togethersoft.sca.internal.jparser.ast.ArrayCreationExpr;
import com.togethersoft.sca.internal.jparser.ast.ArrayInitializer;
import com.togethersoft.sca.internal.jparser.ast.AssertStmt;
import com.togethersoft.sca.internal.jparser.ast.AssignExpr;
import com.togethersoft.sca.internal.jparser.ast.Ast;
import com.togethersoft.sca.internal.jparser.ast.AstVector;
import com.togethersoft.sca.internal.jparser.ast.BinaryExpr;
import com.togethersoft.sca.internal.jparser.ast.BinaryNotExpr;
import com.togethersoft.sca.internal.jparser.ast.Block;
import com.togethersoft.sca.internal.jparser.ast.Brackets;
import com.togethersoft.sca.internal.jparser.ast.BreakStmt;
import com.togethersoft.sca.internal.jparser.ast.BuiltInType;
import com.togethersoft.sca.internal.jparser.ast.CaseLabel;
import com.togethersoft.sca.internal.jparser.ast.CastExpr;
import com.togethersoft.sca.internal.jparser.ast.CatchClause;
import com.togethersoft.sca.internal.jparser.ast.ClassFile;
import com.togethersoft.sca.internal.jparser.ast.ClassInitializer;
import com.togethersoft.sca.internal.jparser.ast.CompilationUnit;
import com.togethersoft.sca.internal.jparser.ast.ConditionalExpr;
import com.togethersoft.sca.internal.jparser.ast.ContinueStmt;
import com.togethersoft.sca.internal.jparser.ast.DbcResultExpr;
import com.togethersoft.sca.internal.jparser.ast.DeclarationStmt;
import com.togethersoft.sca.internal.jparser.ast.DefaultLabel;
import com.togethersoft.sca.internal.jparser.ast.DoStmt;
import com.togethersoft.sca.internal.jparser.ast.EmptyStmt;
import com.togethersoft.sca.internal.jparser.ast.ExprStmt;
import com.togethersoft.sca.internal.jparser.ast.FieldAccess;
import com.togethersoft.sca.internal.jparser.ast.FinallyClause;
import com.togethersoft.sca.internal.jparser.ast.ForStmt;
import com.togethersoft.sca.internal.jparser.ast.FormalParameter;
import com.togethersoft.sca.internal.jparser.ast.IfStmt;
import com.togethersoft.sca.internal.jparser.ast.ImportDeclaration;
import com.togethersoft.sca.internal.jparser.ast.IncDecExpr;
import com.togethersoft.sca.internal.jparser.ast.Inheritance;
import com.togethersoft.sca.internal.jparser.ast.Literal;
import com.togethersoft.sca.internal.jparser.ast.LogicalNotExpr;
import com.togethersoft.sca.internal.jparser.ast.MethodCall;
import com.togethersoft.sca.internal.jparser.ast.MethodDeclaration;
import com.togethersoft.sca.internal.jparser.ast.Modifier;
import com.togethersoft.sca.internal.jparser.ast.Modifiers;
import com.togethersoft.sca.internal.jparser.ast.NewExpr;
import com.togethersoft.sca.internal.jparser.ast.PackageDeclaration;
import com.togethersoft.sca.internal.jparser.ast.ParExpr;
import com.togethersoft.sca.internal.jparser.ast.ReturnStmt;
import com.togethersoft.sca.internal.jparser.ast.SimpleName;
import com.togethersoft.sca.internal.jparser.ast.SuperCall;
import com.togethersoft.sca.internal.jparser.ast.SuperExpr;
import com.togethersoft.sca.internal.jparser.ast.SwitchGroup;
import com.togethersoft.sca.internal.jparser.ast.SwitchStmt;
import com.togethersoft.sca.internal.jparser.ast.SynchronizedStmt;
import com.togethersoft.sca.internal.jparser.ast.ThisCall;
import com.togethersoft.sca.internal.jparser.ast.ThisExpr;
import com.togethersoft.sca.internal.jparser.ast.ThrowSpecifier;
import com.togethersoft.sca.internal.jparser.ast.ThrowStmt;
import com.togethersoft.sca.internal.jparser.ast.TryStmt;
import com.togethersoft.sca.internal.jparser.ast.TypeDeclaration;
import com.togethersoft.sca.internal.jparser.ast.TypeExpr;
import com.togethersoft.sca.internal.jparser.ast.UnaryPlusMinusExpr;
import com.togethersoft.sca.internal.jparser.ast.VariableDeclaration;
import com.togethersoft.sca.internal.jparser.ast.VariableDeclarator;
import com.togethersoft.sca.internal.jparser.ast.Visitor;
import com.togethersoft.sca.internal.jparser.ast.WhileStmt;
import java.io.PrintStream;

public class VisitorPrinter
extends Visitor {
    private PrintStream out;

    public VisitorPrinter(PrintStream out, int options) {
        super(5 | options);
        this.out = out;
    }

    public void printIds(AstVector v) {
        if (v == null) {
            return;
        }
        int i = 0;
        while (i < v.size()) {
            if (i != 0) {
                this.out.print(" #");
            } else {
                this.out.print("#");
            }
            this.out.print(v.at(i).id());
            ++i;
        }
    }

    public void printIds(Ast[] v) {
        if (v == null) {
            return;
        }
        int i = 0;
        while (i < v.length) {
            if (i != 0) {
                this.out.print(" #");
            } else {
                this.out.print("#");
            }
            this.out.print(v[i].id());
            ++i;
        }
    }

    public void visitArrayAccess(ArrayAccess t) {
        this.out.println("#" + t.id() + " (ArrayAccess): #" + t.base.id() + "[ #" + t.index.id() + " ]");
    }

    public void visitArrayCreationExpr(ArrayCreationExpr t) {
        this.out.print("#" + t.id() + " (ArrayCreationExpr): " + t.arrayType.id());
        int i = 0;
        while (i < t.numDimensions()) {
            this.out.print("[ #" + t.dimension(i).id() + " ]");
            ++i;
        }
        if (t.initializer != null) {
            this.out.println(" = #" + t.initializer.id());
        } else {
            this.out.println();
        }
    }

    public void visitArrayInitializer(ArrayInitializer t) {
        this.out.print("#" + t.id() + " (ArrayInitializer): { ");
        this.printIds(t.initializers);
        this.out.println(" }");
    }

    public void visitAssertStmt(AssertStmt t) {
        this.out.print("#" + t.id() + " (AssertStmt): assert #" + t.condition().id());
        if (t.argument() != null) {
            this.out.print(" #" + t.argument().id());
        }
        this.out.println(" ;");
    }

    public void visitAssignExpr(AssignExpr t) {
        this.out.println("#" + t.id() + " (AssignExpr): #" + t.leftExpr().id() + " " + t.getExpressionKind() + " #" + t.rightExpr().id());
    }

    public void visitBinaryExpr(BinaryExpr t) {
        this.out.println("#" + t.id() + " (BinaryExpr): #" + t.leftExpr().id() + " " + t.getExpressionKind() + " #" + t.rightExpr().id());
    }

    public void visitBinaryNotExpr(BinaryNotExpr t) {
        this.out.println("#" + t.id() + " (BinaryNotExpr): " + t.operatorToken().getText() + " #" + t.expression.id());
    }

    public void visitBlock(Block t) {
        this.out.print("#" + t.id() + " (Block): {");
        int i = 0;
        while (i < t.numStatements()) {
            this.out.print(" #" + t.statement(i).id());
            ++i;
        }
        this.out.println(" }");
    }

    public void visitBrackets(Brackets t) {
        this.out.print("#" + t.id() + " (Brackets): [");
        if (t.expr != null) {
            this.out.print(" #" + t.expr.id());
        }
        this.out.println(" ]");
    }

    public void visitBreakStmt(BreakStmt t) {
        this.out.print("#" + t.id() + " (BreakStmt): break");
        if (t.label() != null) {
            this.out.print(" #" + t.label().id());
        }
        this.out.println(" ;");
    }

    public void visitBuiltInType(BuiltInType t) {
        this.out.println("#" + t.id() + " (BuiltInType): " + t.getName());
    }

    public void visitCaseLabel(CaseLabel t) {
        this.out.println("#" + t.id() + " (CaseLabel): case #" + t.expr().id() + " :");
    }

    public void visitCastExpr(CastExpr t) {
        this.out.println("#" + t.id() + " (CastExpr): ( #" + t.typeSpec.id() + ") #" + t.expression.id());
    }

    public void visitCatchClause(CatchClause t) {
        this.out.println("#" + t.id() + " (CatchClause): catch ( #" + t.param().id() + " ) { " + t.body().id() + " }");
    }

    public void visitClassFile(ClassFile t) {
        this.out.print("#" + t.id() + " (ClassFile): " + t.getElementName() + " parent " + t.getParent());
        this.out.println(" type #" + t.getTypeDecl().id());
    }

    public void visitClassInitializer(ClassInitializer t) {
        this.out.print("#" + t.id() + " (ClassInitializer): ");
        if (t.isStatic()) {
            this.out.print("static ");
        }
        this.out.println("#" + t.getBlockBody().id());
    }

    public void visitCompilationUnit(CompilationUnit t) {
        this.out.print("#" + t.id() + " (Compilation unit): " + t.getElementName() + " parent " + t.getParent());
        if (t.importDeclarations != null) {
            this.out.print(" imports ");
            this.printIds(t.importDeclarations);
        }
        if (t.typeDeclarations != null) {
            this.out.print(" types ");
            this.printIds(t.typeDeclarations);
        }
        this.out.println();
    }

    public void visitConditionalExpr(ConditionalExpr t) {
        this.out.println("#" + t.id() + " (ConditionalExpr): #" + t.testExpression.id() + " ? #" + t.trueExpression.id() + " : #" + t.falseExpression.id());
    }

    public void visitContinueStmt(ContinueStmt t) {
        this.out.print("#" + t.id() + " (ContinueStmt): continue");
        if (t.label() != null) {
            this.out.print(" " + t.label().getName());
        }
        this.out.println(" ;");
    }

    public void visitDeclarationStmt(DeclarationStmt t) {
        this.out.println("#" + t.id() + " (DeclarationStmt): #" + t.decl().id());
    }

    public void visitDefaultLabel(DefaultLabel t) {
        this.out.println("#" + t.id() + " (DefaultLabel): default : ");
    }

    public void visitDoStmt(DoStmt t) {
        this.out.println("#" + t.id() + " (DoStmt): do #" + t.body().id() + " while ( #" + t.condition().id() + " ) ;");
    }

    public void visitEmptyStmt(EmptyStmt t) {
        this.out.println("#" + t.id() + " (EmptyStmt)");
    }

    public void visitExprStmt(ExprStmt t) {
        this.out.println("#" + t.id() + " (ExprStmt): #" + t.expr().id() + " ;");
    }

    public void visitFieldAccess(FieldAccess t) {
        this.out.println("#" + t.id() + " (FieldAccess): #" + t.base.id() + " . " + t.getName());
    }

    public void visitFinallyClause(FinallyClause t) {
        this.out.println("#" + t.id() + " (FinallyClause): finally { #" + t.body().id() + " }");
    }

    public void visitFormalParameter(FormalParameter t) {
        this.out.print("#" + t.id() + " (FormalParameter): ");
        if (t.modifiers != null) {
            this.out.print("mods #" + t.modifiers.id() + " ");
        }
        if (t.typeSpec != null) {
            this.out.print("#" + t.typeSpec.id() + " #" + t.declarator.id());
        }
        this.out.println();
    }

    public void visitForStmt(ForStmt t) {
        this.out.print("#" + t.id() + " (ForStmt): for (");
        int i = 0;
        while (i < t.numInitStatements()) {
            this.out.print(" #" + t.initStatement(i).id());
            ++i;
        }
        this.out.print("; ");
        if (t.condition() != null) {
            this.out.print(" #" + t.condition().id() + " ;");
        } else {
            this.out.print(" ;");
        }
        int i2 = 0;
        while (i2 < t.numUpdateStatements()) {
            this.out.print(" #" + t.updateStatement(i2).id());
            ++i2;
        }
        this.out.println(") #" + t.body().id());
    }

    public void visitIfStmt(IfStmt t) {
        this.out.print("#" + t.id() + " (IfStmt): if ( #" + t.condition().id() + " ) #" + t.thenStmt().id());
        if (t.elseStmt() != null) {
            this.out.print(" else #" + t.elseStmt().id());
        }
        this.out.println();
    }

    public void visitImportDeclaration(ImportDeclaration t) {
        this.out.println("#" + t.id() + " (ImportDeclaration): " + (t.importPackage ? "import package" : "import type") + " #" + t.type.id());
    }

    public void visitInheritance(Inheritance t) {
        this.out.println("#" + t.id() + " (Inheritance): " + t.getType().id());
    }

    public void visitLiteral(Literal t) {
        this.out.println("#" + t.id() + " (Literal): " + t.getLiteralKind() + " " + t.getText());
    }

    public void visitLogicalNotExpr(LogicalNotExpr t) {
        this.out.println("#" + t.id() + " (LogicalNotExpr): " + t.opToken.getText() + "#" + t.expression.id());
    }

    public void visitMethodDeclaration(MethodDeclaration t) {
        this.out.print("#" + t.id() + " (MethodDeclaration): ");
        if (t.modifiers != null) {
            this.out.print("mods #" + t.modifiers.id() + " ");
        }
        if (t.retType != null) {
            this.out.print("returns #" + t.retType.id() + " ");
        }
        this.out.print(t.getElementName());
        int i = 0;
        while (i < t.numBrackets()) {
            this.out.print("[ #" + t.brackets(i).id() + " ] ");
            ++i;
        }
        this.out.print("( ");
        this.printIds(t.params);
        this.out.print(" )");
        if (t.throwSpec != null) {
            this.out.print("throws (");
            this.printIds(t.throwSpec);
            this.out.print(") ");
        }
        if (t.body != null) {
            this.out.print("#" + t.body.id());
        }
        this.out.println();
    }

    public void visitMethodCall(MethodCall t) {
        this.out.print("#" + t.id() + " (MethodCall): #" + t.method.id() + " ( ");
        int i = 0;
        while (i < t.numArguments()) {
            this.out.print(" #" + t.argument(i).id());
            ++i;
        }
        this.out.println(" )");
    }

    public void visitModifier(Modifier t) {
        this.out.println("#" + t.id() + " (Modifier): " + t.leftToken().getText());
    }

    public void visitModifiers(Modifiers t) {
        this.out.print("#" + t.id() + " (Modifiers): ");
        int i = 0;
        while (i < t.numModifiers()) {
            this.out.print(" #" + t.modifier(i).id());
            ++i;
        }
        this.out.println();
    }

    public void visitNewExpr(NewExpr t) {
        this.out.print("#" + t.id() + " (NewExpr): ");
        if (t.base != null) {
            this.out.print("#" + t.base.id() + " . ");
        }
        this.out.print("new #" + t.typeSpec.id() + " ( ");
        int i = 0;
        while (i < t.numArguments()) {
            this.out.print(" #" + t.argument(i).id());
            ++i;
        }
        this.out.print(" ) ");
        if (t.classBody != null) {
            this.out.print("{ #" + t.classBody.id() + " }");
        }
        this.out.println();
    }

    public void visitPackageDeclaration(PackageDeclaration t) {
        this.out.print("#" + t.id() + " (PackageDeclaration): package " + t.getElementName());
        if (t.getParent() != null) {
            this.out.print(" parent #" + t.getParent());
        } else {
            this.out.print(" parent null ");
        }
        if (t.subpackages != null) {
            this.out.print(" subpackages ");
            this.printIds(t.subpackages);
        }
        if (t.cunits != null) {
            this.out.print(" compilation units ");
            this.printIds(t.cunits);
        }
        if (t.classFiles != null) {
            this.out.print(" class files ");
            this.printIds(t.classFiles);
        }
        this.out.println();
    }

    public void visitParExpr(ParExpr t) {
        this.out.println("#" + t.id() + " (ParExpr): ( #" + t.expr().id() + " )");
    }

    public void visitIncDecExpr(IncDecExpr t) {
        this.out.println("#" + t.id() + " (IncDecExpr): #" + t.expression.id() + " " + t.getExpressionKind());
    }

    public void visitReturnStmt(ReturnStmt t) {
        this.out.print("#" + t.id() + " (ReturnStmt): return");
        if (t.expr() != null) {
            this.out.print(" #" + t.expr().id());
        }
        this.out.println(" ;");
    }

    public void visitSimpleName(SimpleName t) {
        this.out.println("#" + t.id() + " (SimpleName): " + t.getName());
    }

    public void visitSuperCall(SuperCall t) {
        this.out.print("#" + t.id() + " (SuperCall): ");
        if (t.base() != null) {
            this.out.print("#" + t.base().id() + " ");
        }
        this.out.print(" super (");
        int i = 0;
        while (i < t.numArguments()) {
            this.out.print(" #" + t.argument(i).id());
            ++i;
        }
        this.out.println(" )");
    }

    public void visitSuperExpr(SuperExpr t) {
        this.out.println("#" + t.id() + " (SuperExpr): super");
    }

    public void visitSwitchGroup(SwitchGroup t) {
        this.out.print("#" + t.id() + " (SwitchGroup): ");
        int i = 0;
        while (i < t.numCaseLabels()) {
            this.out.print(" case #" + t.getCaseLabel(i).id() + ":");
            ++i;
        }
        int i2 = 0;
        while (i2 < t.numStatements()) {
            this.out.print(" #" + t.getStatement(i2).id());
            ++i2;
        }
        this.out.println();
    }

    public void visitSwitchStmt(SwitchStmt t) {
        this.out.print("#" + t.id() + " (SwitchStmt): switch ( #" + t.condition().id() + " ) {");
        int i = 0;
        while (i < t.numSwitchGroups()) {
            this.out.print(" #" + t.getSwitchGroup(i));
            ++i;
        }
        this.out.println(" }");
    }

    public void visitSynchronizedStmt(SynchronizedStmt t) {
        this.out.println("#" + t.id() + " (SynchronizedStmt): synchronized ( #" + t.condition().id() + " ) #" + t.body().id());
    }

    public void visitThisCall(ThisCall t) {
        this.out.print("#" + t.id() + " (ThisCall): this ( ");
        int i = 0;
        while (i < t.numArguments()) {
            this.out.print(" #" + t.argument(i).id());
            ++i;
        }
        this.out.println(" )");
    }

    public void visitThisExpr(ThisExpr t) {
        this.out.println("#" + t.id() + " (ThisExpr): this");
    }

    public void visitThrowSpecifier(ThrowSpecifier t) {
        this.out.print("#" + t.id() + " (ThrowSpec): ");
        if (t.getThrowType() != null) {
            this.out.println("#" + t.getThrowType().id());
        } else {
            this.out.println();
        }
    }

    public void visitThrowStmt(ThrowStmt t) {
        this.out.println("#" + t.id() + " (ThrowStmt): throw #" + t.expr().id() + " ;");
    }

    public void visitTryStmt(TryStmt t) {
        this.out.print("#" + t.id() + " (TryStmt): try #" + t.body().id() + " catch [");
        int i = 0;
        while (i < t.numCatchClauses()) {
            this.out.print(" #" + t.catchClause(i).id());
            ++i;
        }
        this.out.print(" ]");
        if (t.finallyClause() != null) {
            this.out.print(" finally #" + t.finallyClause().id());
        }
        this.out.println();
    }

    public void visitTypeDeclaration(TypeDeclaration t) {
        this.out.print("#" + t.id() + " (TypeDeclaration): " + (t.isClass() ? "class " : "interface ") + t.getElementName());
        if (t.modifiers != null) {
            this.out.print(" mods #" + t.modifiers.id() + " ");
        }
        if (t.getSuperType() != null) {
            this.out.print(" super #" + t.getSuperType().id());
        }
        this.out.print(" interfaces ");
        int i = 0;
        while (i < t.numInterfaces()) {
            this.out.print(" #" + t.getInterface(i).id());
            ++i;
        }
        if (t.fields != null) {
            this.out.print(" fields ");
            this.printIds(t.fields);
        }
        if (t.methods != null) {
            this.out.print(" methods ");
            this.printIds(t.methods);
        }
        if (t.nestedTypes != null) {
            this.out.print(" types ");
            this.printIds(t.nestedTypes);
        }
        if (t.constructors != null) {
            this.out.print(" ctors ");
            this.printIds(t.constructors);
        }
        if (t.initializers != null) {
            this.out.print(" initializers ");
            this.printIds(t.initializers);
        }
        this.out.println();
    }

    public void visitTypeExpr(TypeExpr t) {
        this.out.print("#" + t.id() + " (TypeExpr): #" + t.type.id());
        int i = 0;
        while (i < t.numBrackets()) {
            this.out.print(" [ #" + t.brackets(i).id() + " ]");
            ++i;
        }
        this.out.println();
    }

    public void visitUnaryPlusMinusExpr(UnaryPlusMinusExpr t) {
        this.out.println("#" + t.id() + " (UnaryPlusMinusExpr): " + t.opToken.getText() + "#" + t.expression.id());
    }

    public void visitVariableDeclaration(VariableDeclaration t) {
        this.out.print("#" + t.id() + " (VariableDeclaration): ");
        if (t.modifiers != null) {
            this.out.print(" mods #" + t.modifiers.id());
        }
        if (t.typeSpec != null) {
            this.out.print(" type #" + t.typeSpec.id() + " declarators ");
        }
        this.printIds(t.declarators);
        this.out.println();
    }

    public void visitVariableDeclarator(VariableDeclarator t) {
        this.out.print("#" + t.id() + " (VariableDeclarator): " + t.getElementName());
        int i = 0;
        while (i < t.numBrackets()) {
            this.out.print(" [ #" + t.brackets(i).id() + " ]");
            ++i;
        }
        if (t.initializer != null) {
            this.out.println(" = #" + t.initializer.id());
        } else {
            this.out.println();
        }
    }

    public void visitWhileStmt(WhileStmt t) {
        this.out.println("#" + t.id() + " (WhileStmt): while (#" + t.condition().id() + ") #" + t.body().id());
    }

    public void visitDbcResultExpr(DbcResultExpr t) {
        this.out.println("#" + t.id() + " (DbcResult): $result");
    }
}

