/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstComment;
import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstField;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstReference;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.ast.AstTypeReference;
import com.togethersoft.sca.internal.jparser.ast.AssignExpr;
import com.togethersoft.sca.internal.jparser.ast.Ast;
import com.togethersoft.sca.internal.jparser.ast.AstVector;
import com.togethersoft.sca.internal.jparser.ast.Brackets;
import com.togethersoft.sca.internal.jparser.ast.CompilationUnit;
import com.togethersoft.sca.internal.jparser.ast.Declaration;
import com.togethersoft.sca.internal.jparser.ast.Expr;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.PackageDeclaration;
import com.togethersoft.sca.internal.jparser.ast.SimpleName;
import com.togethersoft.sca.internal.jparser.ast.TypeDeclaration;
import com.togethersoft.sca.internal.jparser.ast.Visitor;
import com.togethersoft.sca.internal.jparser.symbol.CDefinition;
import com.togethersoft.sca.internal.jparser.symbol.CTopLevel;
import com.togethersoft.sca.internal.jparser.symbol.CVariable;
import java.io.IOException;
import java.io.ObjectOutputStream;

public class VariableDeclarator
extends Declaration
implements AstField,
AstReference {
    AstVector brackets;
    public JavaToken assignToken;
    public Expr initializer;
    JavaToken idToken;
    Declaration decl;
    private AssignExpr initAssign;
    public CVariable symbol;

    public VariableDeclarator(Declaration decl, JavaToken idToken, JavaToken assignToken, Expr initializer, AstVector brackets) {
        super(null);
        this.decl = decl;
        this.idToken = idToken;
        this.assignToken = assignToken;
        this.initializer = initializer;
        this.brackets = brackets;
        this.setInitializer(initializer);
        if (brackets != null) {
            brackets.setParent(this);
        }
    }

    public int astType() {
        return 29;
    }

    public int getObjectKind() {
        return 9;
    }

    public AstObject[] getChildren() {
        if (this.initializer != null) {
            return new AstObject[]{this.initializer};
        }
        return Ast.EMPTY_NODE_SET;
    }

    public AstComment[] getComments() {
        boolean isFirst;
        AstComment[] comments = super.getComments();
        boolean bl = isFirst = this.decl.getDeclarations()[0] == this;
        if (isFirst) {
            AstComment[] declComments;
            if (comments.length > 0 && (declComments = this.decl.getComments()).length > 0) {
                AstComment[] allComments = new AstComment[comments.length + declComments.length];
                System.arraycopy(comments, 0, allComments, 0, comments.length);
                System.arraycopy(declComments, 0, allComments, comments.length, declComments.length);
                return allComments;
            }
            return this.decl.getComments();
        }
        return comments;
    }

    public AstDeclaration getReferencedElement() {
        if (this.symbol != null) {
            return this.symbol.getType().getAST();
        }
        return null;
    }

    public String getElementName() {
        return this.idToken.getText();
    }

    public String getQualifiedName() {
        return this.symbol.getQualifiedName();
    }

    public CDefinition getSymbol() {
        return this.symbol;
    }

    public int getDeclaredModifiers() {
        return this.decl.getDeclaredModifiers();
    }

    public void setDeclaredModifiers(int mods) {
        this.decl.setDeclaredModifiers(mods);
    }

    public AstTypeReference getType() {
        if (this.symbol.isPending()) {
            this.symbol.process();
        }
        return this.symbol.getType().getExternalType();
    }

    public AstExpression getInitializer() {
        CompilationUnit cu;
        if (this.initializer != null) {
            return this.initializer;
        }
        AstType type = this.getDeclaringType();
        if (type != null && (cu = (CompilationUnit)type.getCompilationUnit()) != null && cu.sourcePending()) {
            ((PackageDeclaration)this.getPackage()).getModel().processSource(cu);
        }
        return this.initializer;
    }

    public String getSignature() {
        return this.symbol.getSignature();
    }

    public void setInitializer(Expr initializer) {
        this.initializer = initializer;
        if (initializer != null) {
            SimpleName var = new SimpleName(this.idToken);
            this.initAssign = new AssignExpr(0, var, null, initializer);
            this.initAssign.setParent(this);
            initializer.setParent(this);
        } else {
            this.initAssign = null;
        }
    }

    AstDeclaration[] getDeclarations() {
        return new AstDeclaration[]{this};
    }

    public int numBrackets() {
        return this.brackets == null ? 0 : this.brackets.size();
    }

    public Brackets brackets(int i) {
        return (Brackets)this.brackets.get(i);
    }

    public void accept(Visitor visitor) {
        visitor.visitVariableDeclarator(this);
    }

    public void traverse(Visitor visitor) {
        if (!visitor.isExternal() && this.brackets != null) {
            this.brackets.action(visitor);
        }
        if ((visitor.getAction() & 4) != 0 && this.initializer != null) {
            this.initializer.action(visitor);
        }
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        if (this.initializer == oldObj) {
            this.initializer = (Expr)newObj;
        }
        return AstVector.replace(this.brackets, oldObj, newObj);
    }

    public JavaToken leftToken() {
        return this.idToken;
    }

    public JavaToken rightToken() {
        if (this.initializer != null) {
            return this.initializer.rightToken();
        }
        if (this.numBrackets() > 0) {
            return ((Brackets)this.brackets.get(this.brackets.size() - 1)).rightToken();
        }
        return this.idToken;
    }

    void setReferee(Declaration decl) {
        TypeDeclaration type = (TypeDeclaration)decl;
        this.symbol.setType(type.symbol.getArrayType((CTopLevel)type.symbol.getPackage().getParent(), this.symbol.getType().numDimensions()));
        type.symbol.addDependence(this.symbol.getInnermostType());
        this.setSymbol(this.symbol);
    }

    public void setSymbol(CVariable symbol) {
        this.symbol = symbol;
        symbol.getType().addReference(this);
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        this.initializer = null;
        this.removeDeepReferences();
        s.defaultWriteObject();
    }

    public AssignExpr getInitializerAssignment() {
        return this.initAssign;
    }
}

