/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstDeclarationStatement;
import com.togethersoft.sca.ast.AstField;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstTypeReference;
import com.togethersoft.sca.ast.AstVarDeclaration;
import com.togethersoft.sca.internal.jparser.ast.Ast;
import com.togethersoft.sca.internal.jparser.ast.AstVector;
import com.togethersoft.sca.internal.jparser.ast.Declaration;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.Modifiers;
import com.togethersoft.sca.internal.jparser.ast.TypeExpr;
import com.togethersoft.sca.internal.jparser.ast.VariableDeclarator;
import com.togethersoft.sca.internal.jparser.ast.Visitor;
import com.togethersoft.sca.internal.jparser.symbol.CDefinition;

public class VariableDeclaration
extends Declaration
implements AstVarDeclaration {
    public TypeExpr typeSpec;
    public VariableDeclarator[] declarators;

    public VariableDeclaration(Modifiers modifiers, TypeExpr typeSpec) {
        super(modifiers);
        this.typeSpec = typeSpec;
        if (typeSpec != null) {
            typeSpec.setParent(this);
        }
    }

    public int astType() {
        return 28;
    }

    public AstTypeReference getType() {
        return this.typeSpec.getType();
    }

    public AstField[] getFields() {
        AstField[] arr = new AstField[this.declarators.length];
        System.arraycopy(this.declarators, 0, arr, 0, this.declarators.length);
        return arr;
    }

    public int getObjectKind() {
        return 50;
    }

    public AstObject[] getChildren() {
        return Ast.EMPTY_NODE_SET;
    }

    public String getElementName() {
        return null;
    }

    AstDeclaration[] getDeclarations() {
        AstDeclaration[] arr = new AstDeclaration[this.declarators.length];
        System.arraycopy(this.declarators, 0, arr, 0, this.declarators.length);
        return arr;
    }

    public CDefinition getSymbol() {
        return null;
    }

    public int numDeclarators() {
        return this.declarators.length;
    }

    public VariableDeclarator getDeclarator(int i) {
        return this.declarators[i];
    }

    public void setDeclarators(AstVector v) {
        this.declarators = new VariableDeclarator[v.size()];
        v.toArray(this.declarators);
    }

    public void setDeclarators(VariableDeclarator d) {
        this.declarators = new VariableDeclarator[]{d};
    }

    public void setParent(Ast parent) {
        super.setParent(parent);
        if (!(parent instanceof AstDeclarationStatement)) {
            parent = this;
        }
        int i = 0;
        while (i < this.numDeclarators()) {
            this.getDeclarator(i).setParent(parent);
            ++i;
        }
    }

    public void accept(Visitor visitor) {
        visitor.visitVariableDeclaration(this);
    }

    public void traverse(Visitor visitor) {
        if (!visitor.isExternal()) {
            if (this.modifiers != null) {
                this.modifiers.action(visitor);
            }
            if (this.typeSpec != null) {
                this.typeSpec.action(visitor);
            }
        }
        int i = 0;
        while (i < this.declarators.length) {
            this.declarators[i].action(visitor);
            ++i;
        }
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        if (this.modifiers == oldObj) {
            this.modifiers = (Modifiers)newObj;
        } else if (this.typeSpec == oldObj) {
            this.typeSpec = (TypeExpr)newObj;
        } else {
            int i = 0;
            while (i < this.declarators.length) {
                if (this.declarators[i] == oldObj) {
                    this.declarators[i] = (VariableDeclarator)newObj;
                    return true;
                }
                ++i;
            }
            return false;
        }
        return true;
    }

    public JavaToken leftToken() {
        if (this.typeSpec == null) {
            return null;
        }
        if (this.modifiers != null) {
            JavaToken tkn = this.modifiers.leftToken();
            return tkn != null ? tkn : this.typeSpec.leftToken();
        }
        return this.typeSpec.leftToken();
    }

    public JavaToken rightToken() {
        return this.declarators[this.declarators.length - 1].rightToken();
    }
}

