/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstTypeExpression;
import com.togethersoft.sca.internal.jparser.ast.AstVector;
import com.togethersoft.sca.internal.jparser.ast.Brackets;
import com.togethersoft.sca.internal.jparser.ast.Expr;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.Name;
import com.togethersoft.sca.internal.jparser.ast.Visitor;

public class TypeExpr
extends Expr
implements AstTypeExpression {
    public Name type;
    AstVector brackets = null;

    public TypeExpr(Name type) {
        this.type = type;
        type.setParent(this);
    }

    public int astType() {
        return 27;
    }

    public int getObjectKind() {
        return 45;
    }

    public AstExpression[] getOperands() {
        return Expr.NO_OPERANDS;
    }

    public void addBrackets(Brackets br) {
        if (this.brackets == null) {
            this.brackets = new AstVector();
        }
        this.brackets.add(br);
        br.setParent(this);
    }

    public int numBrackets() {
        return this.brackets == null ? 0 : this.brackets.size();
    }

    public Brackets brackets(int i) {
        return (Brackets)this.brackets.get(i);
    }

    public String getFullName() {
        String str = this.type.getFullName();
        int i = 0;
        while (i < this.numBrackets()) {
            str = str + "[]";
            ++i;
        }
        return str;
    }

    public void accept(Visitor visitor) {
        if (visitor.exprVisitor != null) {
            visitor.exprVisitor.visitTypeExpression(this);
        } else {
            visitor.visitTypeExpr(this);
        }
    }

    public void traverse(Visitor visitor) {
        if (!visitor.isExternal()) {
            this.type.action(visitor);
            if (this.brackets != null) {
                this.brackets.action(visitor);
            }
        }
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        if (this.type == oldObj) {
            this.type = (Name)newObj;
            return true;
        }
        return AstVector.replace(this.brackets, oldObj, newObj);
    }

    public JavaToken leftToken() {
        return this.type.leftToken();
    }

    public JavaToken rightToken() {
        if (this.brackets == null) {
            return this.type.rightToken();
        }
        return ((Brackets)this.brackets.get(this.brackets.size() - 1)).rightToken();
    }
}

