/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstClassFile;
import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstField;
import com.togethersoft.sca.ast.AstInitializer;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.ast.AstTypeReference;
import com.togethersoft.sca.ast.AstVarDeclaration;
import com.togethersoft.sca.internal.jparser.ast.AstVector;
import com.togethersoft.sca.internal.jparser.ast.ClassInitializer;
import com.togethersoft.sca.internal.jparser.ast.Declaration;
import com.togethersoft.sca.internal.jparser.ast.Inheritance;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.MethodDeclaration;
import com.togethersoft.sca.internal.jparser.ast.Modifiers;
import com.togethersoft.sca.internal.jparser.ast.VariableDeclaration;
import com.togethersoft.sca.internal.jparser.ast.Visitor;
import com.togethersoft.sca.internal.jparser.dbc.CommentParser;
import com.togethersoft.sca.internal.jparser.symbol.CClassType;
import com.togethersoft.sca.internal.jparser.symbol.CCompilationUnit;
import com.togethersoft.sca.internal.jparser.symbol.CDefinition;
import com.togethersoft.sca.internal.jparser.symbol.CMethod;
import com.togethersoft.sca.internal.jparser.symbol.CVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;

public class TypeDeclaration
extends Declaration
implements AstType {
    public static final int CLASS = 1;
    public static final int INTERFACE = 2;
    private int kind;
    public String typeName;
    public JavaToken nameToken;
    private Inheritance superType;
    private AstVector interfaces;
    public AstVector fields = null;
    public AstVector methods = null;
    public AstVector nestedTypes = null;
    public AstVector initializers = null;
    public AstVector constructors = null;
    public JavaToken classToken;
    public JavaToken extendsToken;
    public JavaToken implementsToken;
    public JavaToken leftBrace;
    public JavaToken rightBrace;
    public CClassType symbol;
    public CCompilationUnit sourceFile;
    private MethodDeclaration instanceInitializer;
    private MethodDeclaration classInitializer;
    private AstExpression[] invariants;
    private static final AstField[] NO_FIELDS = new AstField[0];
    private static final AstMethod[] NO_METHODS = new AstMethod[0];

    public TypeDeclaration() {
        super(null);
    }

    public TypeDeclaration(int kind, String typeName, Modifiers modifiers) {
        super(modifiers);
        this.kind = kind;
        this.typeName = typeName;
    }

    public TypeDeclaration(int kind, JavaToken classToken, JavaToken nameToken, Modifiers modifiers) {
        this(kind, nameToken.getText(), modifiers);
        this.classToken = classToken;
        this.nameToken = nameToken;
        if (modifiers != null) {
            modifiers.setParent(this);
        }
    }

    public int astType() {
        return 26;
    }

    public int getObjectKind() {
        return 8;
    }

    public AstObject[] getChildren() {
        int nMethods = this.numMethods();
        int nCtors = this.numConstructors();
        int nInits = this.numInitializers();
        AstField[] fields = this.getFields();
        int nTypes = this.numNestedTypes();
        int size = nMethods + nCtors + nInits + fields.length + nTypes;
        AstObject[] arr = new AstObject[size];
        int idx = 0;
        int i = 0;
        while (i < nMethods) {
            arr[idx++] = this.getMethod(i);
            ++i;
        }
        int i2 = 0;
        while (i2 < nCtors) {
            arr[idx++] = this.getConstructor(i2);
            ++i2;
        }
        int i3 = 0;
        while (i3 < nInits) {
            arr[idx++] = this.getInitializer(i3);
            ++i3;
        }
        int i4 = 0;
        while (i4 < fields.length) {
            arr[idx++] = fields[i4];
            ++i4;
        }
        int i5 = 0;
        while (i5 < nTypes) {
            arr[idx++] = this.getNestedType(i5);
            ++i5;
        }
        return arr;
    }

    public String getElementName() {
        return this.typeName;
    }

    public AstField[] getFields() {
        if (this.fields == null) {
            return NO_FIELDS;
        }
        int count = 0;
        int i = 0;
        while (i < this.numFields()) {
            count += this.getField(i).numDeclarators();
            ++i;
        }
        AstField[] arrFields = new AstField[count];
        count = 0;
        int i2 = 0;
        while (i2 < this.numFields()) {
            int j = 0;
            while (j < this.getField(i2).numDeclarators()) {
                arrFields[count++] = this.getField(i2).getDeclarator(j);
                ++j;
            }
            ++i2;
        }
        return arrFields;
    }

    public AstField findField(String name, boolean searchInherited) {
        CVariable v = searchInherited ? this.symbol.lookupVariable(name) : this.symbol.lookupVariableWithoutInheritance(name);
        return v != null ? (AstField)((Object)v.getAST()) : null;
    }

    public AstMethod findMethod(String name, String signature, boolean searchInherited) {
        CMethod m = searchInherited ? this.symbol.lookupMethod(name, signature) : this.symbol.findMethod(name, signature);
        return m != null ? (AstMethod)((Object)m.getAST()) : null;
    }

    public AstType findType(String name, boolean searchInherited) {
        CClassType cls = searchInherited ? this.symbol.lookupType(name) : this.symbol.lookupTypeWithoutInheritance(name);
        return cls != null ? (AstType)((Object)cls.getAST()) : null;
    }

    public String getQualifiedName() {
        return this.symbol.getQualifiedName();
    }

    public AstInitializer[] getInitializers() {
        if (this.initializers == null) {
            return new AstInitializer[0];
        }
        AstInitializer[] arrInitializers = new AstInitializer[this.initializers.size()];
        this.initializers.toArray(arrInitializers);
        return arrInitializers;
    }

    public AstMethod[] getMethods() {
        if (this.methods == null) {
            return NO_METHODS;
        }
        return this.methods.toArray(new AstMethod[this.methods.size()]);
    }

    public AstMethod[] getExecutableFragments() {
        AstMethod[] arrMethods = new AstMethod[this.numMethods() + this.numConstructors() + this.numInitializers()];
        int count = 0;
        int i = 0;
        while (i < this.numMethods()) {
            arrMethods[count++] = this.getMethod(i);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.numConstructors()) {
            arrMethods[count++] = this.getConstructor(i2);
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.numInitializers()) {
            arrMethods[count++] = this.getInitializer(i3);
            ++i3;
        }
        return arrMethods;
    }

    public AstMethod[] getConstructors() {
        if (this.constructors == null) {
            return new AstMethod[0];
        }
        return this.constructors.toArray(new AstMethod[this.constructors.size()]);
    }

    public AstVarDeclaration[] getVarDeclarations() {
        if (this.fields == null) {
            return new AstVarDeclaration[0];
        }
        return this.fields.toArray(new AstVarDeclaration[this.fields.size()]);
    }

    public AstType getSuperClass() {
        CClassType superclass = this.symbol.getSuperClass();
        return superclass != null ? (AstType)((Object)superclass.getAST()) : null;
    }

    public AstType[] getSuperInterfaces() {
        AstType[] arrIfaces = new AstType[this.symbol.numInterfaces()];
        int i = 0;
        while (i < this.symbol.numInterfaces()) {
            arrIfaces[i] = (AstType)((Object)this.symbol.getInterface(i).getAST());
            ++i;
        }
        return arrIfaces;
    }

    public AstType[] getSubtypes() {
        AstType[] subtypes = new AstType[this.symbol.numSubclasses()];
        int i = 0;
        while (i < subtypes.length) {
            subtypes[i] = (AstType)((Object)this.symbol.getSubclass(i).getAST());
            ++i;
        }
        return subtypes;
    }

    public boolean isDerivedFrom(AstType type) {
        if (type == null) {
            return false;
        }
        return this.symbol.descendsFrom(((TypeDeclaration)type).symbol);
    }

    public boolean isDerivedFrom(String typeName) {
        if (typeName == null) {
            return false;
        }
        return this.symbol.descendsFrom(typeName);
    }

    public boolean isDerivedFrom(AstTypeReference type) {
        if (type == null) {
            return false;
        }
        return this.symbol.isDerivedFrom(type);
    }

    public String getTypeQualifiedName() {
        return this.symbol.getScopedClassName();
    }

    public AstType[] getTypes() {
        if (this.nestedTypes == null) {
            return new AstType[0];
        }
        AstType[] arrTypes = new AstType[this.nestedTypes.size()];
        this.nestedTypes.toArray(arrTypes);
        return arrTypes;
    }

    public boolean isClass() {
        return this.kind == 1;
    }

    public boolean isInterface() {
        return this.kind == 2;
    }

    public boolean isSource() {
        return this.symbol.hasSourceFile();
    }

    public boolean isBinary() {
        return !this.isSource();
    }

    public AstClassFile getClassFile() {
        AstObject parent = this.getParent();
        while (parent != null && !(parent instanceof AstClassFile)) {
            parent = parent.getParent();
        }
        return (AstClassFile)parent;
    }

    public AstType[] getImportCouplings() {
        return this.getCoupledTypes(this.symbol.getImportCouplings());
    }

    public AstType[] getExportCouplings() {
        return this.getCoupledTypes(this.symbol.getExportCouplings());
    }

    private AstType[] getCoupledTypes(Collection couplings) {
        AstType[] arr = new AstType[couplings.size()];
        int index = 0;
        Iterator i = couplings.iterator();
        while (i.hasNext()) {
            CClassType cls = (CClassType)i.next();
            arr[index++] = (AstType)((Object)cls.getAST());
        }
        return arr;
    }

    public int getKind() {
        return this.symbol.getKind();
    }

    public String getTypeName() {
        return this.symbol.getTypeName();
    }

    public int numDimensions() {
        return this.symbol.numDimensions();
    }

    public AstType getBaseType() {
        return this.symbol.getBaseType();
    }

    public String getSignature() {
        return this.symbol.getSignature();
    }

    public boolean isAssignableTo(AstTypeReference type) {
        return this.symbol.isAssignableTo(type);
    }

    AstDeclaration[] getDeclarations() {
        return new AstDeclaration[]{this};
    }

    public AstDeclaration[] getMembers() {
        ArrayList membersList = new ArrayList();
        if (this.fields != null) {
            membersList.addAll(this.fields);
        }
        if (this.methods != null) {
            membersList.addAll(this.methods);
        }
        if (this.constructors != null) {
            membersList.addAll(this.constructors);
        }
        if (this.initializers != null) {
            membersList.addAll(this.initializers);
        }
        if (this.nestedTypes != null) {
            membersList.addAll(this.nestedTypes);
        }
        AstDeclaration[] members = membersList.toArray(new AstDeclaration[membersList.size()]);
        Arrays.sort(members, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                Declaration d0 = (Declaration)arg0;
                Declaration d1 = (Declaration)arg1;
                int lineDelta = d0.getAdjustedLine() - d1.getAdjustedLine();
                return lineDelta != 0 ? lineDelta : d0.getStartColumn() - d1.getStartColumn();
            }

            public boolean equals(Object arg0) {
                return false;
            }
        });
        return members;
    }

    public Inheritance getSuperType() {
        return this.superType;
    }

    public void setSuperType(Inheritance superType) {
        this.superType = superType;
        if (superType != null) {
            superType.setParent(this);
        }
    }

    public void setSuperInterfaces(AstVector interfaces) {
        this.interfaces = interfaces;
        if (interfaces != null) {
            interfaces.setParent(this);
        }
    }

    public int numInterfaces() {
        return this.interfaces == null ? 0 : this.interfaces.size();
    }

    public Inheritance getInterface(int i) {
        return (Inheritance)this.interfaces.get(i);
    }

    public int numFields() {
        return this.fields == null ? 0 : this.fields.size();
    }

    public VariableDeclaration getField(int i) {
        return (VariableDeclaration)this.fields.get(i);
    }

    public void addField(VariableDeclaration f) {
        if (this.fields == null) {
            this.fields = new AstVector();
        }
        this.fields.add(f);
        f.setParent(this);
    }

    public int numClassInitializers() {
        return this.initializers == null ? 0 : this.initializers.size();
    }

    public ClassInitializer getClassInitializer(int i) {
        return (ClassInitializer)this.initializers.get(i);
    }

    public void addClassInitializer(ClassInitializer clinit) {
        if (this.initializers == null) {
            this.initializers = new AstVector();
        }
        this.initializers.add(clinit);
        clinit.setParent(this);
    }

    public int numMethods() {
        return this.methods == null ? 0 : this.methods.size();
    }

    public MethodDeclaration getMethod(int i) {
        return (MethodDeclaration)this.methods.get(i);
    }

    public void addMethod(MethodDeclaration m) {
        if (this.methods == null) {
            this.methods = new AstVector();
        }
        this.methods.add(m);
        m.setParent(this);
    }

    public int numNestedTypes() {
        return this.nestedTypes == null ? 0 : this.nestedTypes.size();
    }

    public TypeDeclaration getNestedType(int i) {
        return (TypeDeclaration)this.nestedTypes.get(i);
    }

    public void addNestedType(TypeDeclaration t) {
        if (this.nestedTypes == null) {
            this.nestedTypes = new AstVector();
        }
        this.nestedTypes.add(t);
        t.setParent(this);
    }

    public int numConstructors() {
        return this.constructors == null ? 0 : this.constructors.size();
    }

    public void addConstructor(MethodDeclaration c) {
        if (this.constructors == null) {
            this.constructors = new AstVector();
        }
        this.constructors.add(c);
        c.setParent(this);
    }

    public MethodDeclaration getConstructor(int i) {
        return (MethodDeclaration)this.constructors.get(i);
    }

    public int numInitializers() {
        return this.initializers != null ? this.initializers.size() : 0;
    }

    public ClassInitializer getInitializer(int i) {
        return (ClassInitializer)this.initializers.get(i);
    }

    public void accept(Visitor visitor) {
        visitor.visitTypeDeclaration(this);
    }

    public void traverse(Visitor visitor) {
        if (this.modifiers != null) {
            this.modifiers.action(visitor);
        }
        if (this.superType != null) {
            this.superType.action(visitor);
        }
        if (this.interfaces != null) {
            this.interfaces.action(visitor);
        }
        if (this.fields != null) {
            this.fields.action(visitor);
        }
        if (this.methods != null) {
            this.methods.action(visitor);
        }
        if (this.nestedTypes != null) {
            this.nestedTypes.action(visitor);
        }
        if (this.constructors != null) {
            this.constructors.action(visitor);
        }
        if (this.initializers != null) {
            this.initializers.action(visitor);
        }
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        if (this.modifiers == oldObj) {
            this.modifiers = (Modifiers)newObj;
        } else if (this.superType == oldObj) {
            this.superType = (Inheritance)newObj;
        } else {
            return AstVector.replace(this.interfaces, oldObj, newObj) || AstVector.replace(this.methods, oldObj, newObj) || AstVector.replace(this.fields, oldObj, newObj) || AstVector.replace(this.nestedTypes, oldObj, newObj) || AstVector.replace(this.constructors, oldObj, newObj) || AstVector.replace(this.initializers, oldObj, newObj);
        }
        return true;
    }

    public JavaToken leftToken() {
        if (this.classToken == null) {
            return this.leftBrace;
        }
        if (this.modifiers != null) {
            JavaToken tkn = this.modifiers.leftToken();
            return tkn != null ? tkn : this.classToken;
        }
        return this.classToken;
    }

    public JavaToken rightToken() {
        return this.rightBrace;
    }

    public CDefinition getSymbol() {
        return this.symbol;
    }

    public MethodDeclaration getClassInitializer() {
        return this.classInitializer;
    }

    public void setClassInitializer(MethodDeclaration classInitializer) {
        this.classInitializer = classInitializer;
    }

    public MethodDeclaration getInstanceInitializer() {
        return this.instanceInitializer;
    }

    public void setInstanceInitializer(MethodDeclaration instanceInitializer) {
        this.instanceInitializer = instanceInitializer;
    }

    public AstField[] getAllFields() {
        Collection c = this.symbol.getAllFields();
        AstField[] arr = new AstField[c.size()];
        Iterator iterator = c.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            CVariable element = (CVariable)iterator.next();
            arr[i++] = (AstField)((Object)element.getAST());
        }
        return arr;
    }

    public AstMethod[] getAllMethods() {
        Collection c = this.symbol.getAllMethods();
        AstMethod[] arr = new AstMethod[c.size()];
        Iterator iterator = c.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            CMethod element = (CMethod)iterator.next();
            arr[i++] = (AstMethod)((Object)element.getAST());
        }
        return arr;
    }

    public AstExpression[] getInvariants() {
        if (this.invariants == null) {
            this.invariants = CommentParser.getInvariants(this);
        }
        return this.invariants;
    }
}

