/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstCatchClause;
import com.togethersoft.sca.ast.AstCompoundStatement;
import com.togethersoft.sca.ast.AstFinallyClause;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstTryStatement;
import com.togethersoft.sca.internal.jparser.ast.AstVector;
import com.togethersoft.sca.internal.jparser.ast.Block;
import com.togethersoft.sca.internal.jparser.ast.CatchClause;
import com.togethersoft.sca.internal.jparser.ast.FinallyClause;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.Stmt;
import com.togethersoft.sca.internal.jparser.ast.Visitor;

public class TryStmt
extends Stmt
implements AstTryStatement {
    private JavaToken tryToken;
    private Block body;
    private AstVector catchClauses;
    private FinallyClause finallyClause;

    public TryStmt(JavaToken tryToken, Block body, AstVector catchClauses, FinallyClause finallyClause) {
        this.tryToken = tryToken;
        this.body = body;
        this.catchClauses = catchClauses;
        this.finallyClause = finallyClause;
        body.setParent(this);
        if (catchClauses != null) {
            catchClauses.setParent(this);
        }
        if (finallyClause != null) {
            finallyClause.setParent(this);
        }
    }

    public int astType() {
        return 51;
    }

    public int getObjectKind() {
        return 11;
    }

    public AstObject[] getChildren() {
        int nHandlers = this.numCatchClauses();
        if (this.finallyClause != null) {
            ++nHandlers;
        }
        AstObject[] arr = new AstObject[nHandlers + 1];
        if (this.catchClauses != null) {
            this.catchClauses.toArray(arr);
        }
        if (this.finallyClause != null) {
            arr[arr.length - 2] = this.finallyClause;
        }
        arr[arr.length - 1] = this.body;
        return arr;
    }

    public AstCompoundStatement getBody() {
        return this.body;
    }

    public AstCatchClause[] getCatchClauses() {
        if (this.catchClauses == null) {
            return new AstCatchClause[0];
        }
        AstCatchClause[] arrCatchClauses = new AstCatchClause[this.catchClauses.size()];
        this.catchClauses.toArray(arrCatchClauses);
        return arrCatchClauses;
    }

    public AstFinallyClause getFinallyClause() {
        return this.finallyClause;
    }

    public Block body() {
        return this.body;
    }

    public int numCatchClauses() {
        return this.catchClauses.size();
    }

    public CatchClause catchClause(int i) {
        return (CatchClause)this.catchClauses.get(i);
    }

    public FinallyClause finallyClause() {
        return this.finallyClause;
    }

    public void accept(Visitor visitor) {
        if (visitor.stmtVisitor != null) {
            visitor.stmtVisitor.visitTryStatement(this);
        } else {
            visitor.visitTryStmt(this);
        }
    }

    public void traverse(Visitor visitor) {
        this.body.action(visitor);
        this.catchClauses.action(visitor);
        if (this.finallyClause != null) {
            this.finallyClause.action(visitor);
        }
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        if (this.body == oldObj) {
            this.body = (Block)newObj;
        } else if (this.finallyClause == oldObj) {
            this.finallyClause = (FinallyClause)newObj;
        } else {
            return AstVector.replace(this.catchClauses, oldObj, newObj);
        }
        return true;
    }

    public JavaToken leftToken() {
        return this.tryToken;
    }

    public JavaToken rightToken() {
        return this.finallyClause != null ? this.finallyClause.rightToken() : this.catchClauses.at(this.catchClauses.size() - 1).rightToken();
    }
}

