/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstThrowSpecifier;
import com.togethersoft.sca.internal.jparser.ast.Ast;
import com.togethersoft.sca.internal.jparser.ast.Declaration;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.Name;
import com.togethersoft.sca.internal.jparser.ast.TypeDeclaration;
import com.togethersoft.sca.internal.jparser.ast.Visitor;
import com.togethersoft.sca.internal.jparser.symbol.CType;

public class ThrowSpecifier
extends Ast
implements AstThrowSpecifier {
    private Name throwType;
    public CType type;

    public ThrowSpecifier(Name throwType) {
        this.throwType = throwType;
        if (throwType != null) {
            throwType.setParent(this);
        }
    }

    public int astType() {
        return 5;
    }

    public int getObjectKind() {
        return 4;
    }

    public AstObject[] getChildren() {
        return Ast.EMPTY_NODE_SET;
    }

    public AstDeclaration getReferencedElement() {
        if (this.type != null) {
            return this.type.getAST();
        }
        return null;
    }

    public Name getThrowType() {
        return this.throwType;
    }

    public void accept(Visitor visitor) {
        visitor.visitThrowSpecifier(this);
    }

    public void traverse(Visitor visitor) {
        if (this.throwType != null) {
            this.throwType.action(visitor);
        }
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        if (this.throwType == oldObj) {
            this.throwType = (Name)newObj;
            return true;
        }
        return false;
    }

    public JavaToken leftToken() {
        return this.throwType.leftToken();
    }

    public JavaToken rightToken() {
        return this.throwType.rightToken();
    }

    public void setSymbol(CType symbol) {
        this.type = symbol;
        symbol.addReference(this);
    }

    void setReferee(Declaration decl) {
        this.setSymbol(((TypeDeclaration)decl).symbol);
        this.type.addDependence(((TypeDeclaration)this.getDeclaringType()).symbol);
    }
}

