/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstConstructorInvocation;
import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.internal.jparser.ast.AstVector;
import com.togethersoft.sca.internal.jparser.ast.Expr;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.ThisExpr;
import com.togethersoft.sca.internal.jparser.ast.Visitor;

public class ThisCall
extends Expr
implements AstConstructorInvocation {
    public ThisExpr thisKeyword;
    public JavaToken leftParen;
    private AstVector arguments;
    public JavaToken rightParen;
    public AstDeclaration ctor;

    public ThisCall(ThisExpr thisKeyword, JavaToken leftParen, AstVector arguments, JavaToken rightParen) {
        this.thisKeyword = thisKeyword;
        this.leftParen = leftParen;
        this.arguments = arguments;
        this.rightParen = rightParen;
        thisKeyword.setParent(this);
        if (arguments != null) {
            arguments.setParent(this);
        }
    }

    public int astType() {
        return 58;
    }

    public int getObjectKind() {
        return 29;
    }

    public AstExpression[] getOperands() {
        return this.getArguments();
    }

    public boolean isSuperCall() {
        return false;
    }

    public boolean isThisCall() {
        return true;
    }

    public AstExpression getBase() {
        return null;
    }

    public AstExpression[] getArguments() {
        return this.toExprArray(this.arguments);
    }

    public AstDeclaration getReferencedElement() {
        return this.ctor;
    }

    public int numArguments() {
        return this.arguments == null ? 0 : this.arguments.size();
    }

    public Expr argument(int i) {
        return (Expr)this.arguments.get(i);
    }

    public AstVector getArgumentsVector() {
        return this.arguments;
    }

    public void accept(Visitor visitor) {
        if (visitor.exprVisitor != null) {
            visitor.exprVisitor.visitConstructorInvocation(this);
        } else {
            visitor.visitThisCall(this);
        }
    }

    public void traverse(Visitor visitor) {
        if (this.arguments != null) {
            this.arguments.action(visitor);
        }
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        return AstVector.replace(this.arguments, oldObj, newObj);
    }

    public JavaToken leftToken() {
        return this.thisKeyword.leftToken();
    }

    public JavaToken rightToken() {
        return this.rightParen;
    }
}

