/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstCompoundStatement;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstSynchronizedStatement;
import com.togethersoft.sca.internal.jparser.ast.Block;
import com.togethersoft.sca.internal.jparser.ast.Expr;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.ParExpr;
import com.togethersoft.sca.internal.jparser.ast.Stmt;
import com.togethersoft.sca.internal.jparser.ast.Visitor;

public class SynchronizedStmt
extends Stmt
implements AstSynchronizedStatement {
    public JavaToken syncToken;
    private ParExpr condition;
    private Block body;

    public SynchronizedStmt(JavaToken syncToken, ParExpr condition, Block body) {
        this.syncToken = syncToken;
        this.condition = condition;
        this.body = body;
        condition.setParent(this);
        body.setParent(this);
    }

    public int astType() {
        return 45;
    }

    public int getObjectKind() {
        return 12;
    }

    public AstObject[] getChildren() {
        return new AstObject[]{this.condition.expr(), this.body};
    }

    public AstExpression getExpression() {
        return this.condition.expr();
    }

    public AstCompoundStatement getBody() {
        return this.body;
    }

    public Expr condition() {
        return this.condition;
    }

    public Block body() {
        return this.body;
    }

    public void accept(Visitor visitor) {
        if (visitor.stmtVisitor != null) {
            visitor.stmtVisitor.visitSynchronizedStatement(this);
        } else {
            visitor.visitSynchronizedStmt(this);
        }
    }

    public void traverse(Visitor visitor) {
        this.condition.action(visitor);
        this.body.action(visitor);
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        if (this.condition == oldObj) {
            this.condition = (ParExpr)newObj;
        } else if (this.body == oldObj) {
            this.body = (Block)newObj;
        } else {
            return false;
        }
        return true;
    }

    public JavaToken leftToken() {
        return this.syncToken;
    }

    public JavaToken rightToken() {
        return this.body.rightToken();
    }
}

