/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstCaseLabel;
import com.togethersoft.sca.ast.AstComment;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstSwitchGroup;
import com.togethersoft.sca.ast.AstSwitchStatement;
import com.togethersoft.sca.internal.jparser.ast.AstVector;
import com.togethersoft.sca.internal.jparser.ast.Expr;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.ParExpr;
import com.togethersoft.sca.internal.jparser.ast.Stmt;
import com.togethersoft.sca.internal.jparser.ast.SwitchGroup;
import com.togethersoft.sca.internal.jparser.ast.Visitor;

public class SwitchStmt
extends Stmt
implements AstSwitchStatement {
    private JavaToken switchToken;
    private ParExpr condition;
    public JavaToken leftBrace;
    private AstVector body;
    public JavaToken rightBrace;
    private SwitchGroup defaultGroup;

    public SwitchStmt(JavaToken switchToken, ParExpr condition, JavaToken leftBrace, AstVector body, JavaToken rightBrace, SwitchGroup defaultGroup) {
        this.switchToken = switchToken;
        this.condition = condition;
        this.leftBrace = leftBrace;
        this.body = body;
        this.rightBrace = rightBrace;
        this.defaultGroup = defaultGroup;
        condition.setParent(this);
        body.setParent(this);
    }

    public int astType() {
        return 53;
    }

    public int getObjectKind() {
        return 13;
    }

    public AstObject[] getChildren() {
        if (this.body == null) {
            return new AstObject[]{this.condition.expr()};
        }
        AstObject[] arr = new AstObject[this.body.size() + 1];
        this.body.toArray(arr);
        arr[arr.length - 1] = this.condition.expr();
        return arr;
    }

    public AstComment[] getComments() {
        return this.getComments(new JavaToken[]{this.switchToken, this.leftBrace, this.rightBrace});
    }

    public AstExpression getCondition() {
        return this.condition.expr();
    }

    public AstSwitchGroup[] getBody() {
        if (this.body == null) {
            return new AstSwitchGroup[0];
        }
        return this.body.toArray(new AstSwitchGroup[this.body.size()]);
    }

    public AstSwitchGroup getDefaultGroup() {
        return this.defaultGroup;
    }

    public AstCaseLabel getCaseLabel(int i1) {
        int i = i1;
        int j = 0;
        while (j < this.numSwitchGroups()) {
            if (i < this.getSwitchGroup(j).numCaseLabels()) {
                return (AstCaseLabel)((Object)this.getSwitchGroup(j).getCaseLabel(i));
            }
            i -= this.getSwitchGroup(j).numCaseLabels();
            ++j;
        }
        return null;
    }

    public Expr condition() {
        return this.condition;
    }

    public int numSwitchGroups() {
        return this.body != null ? this.body.size() : 0;
    }

    public SwitchGroup getSwitchGroup(int i) {
        return (SwitchGroup)this.body.get(i);
    }

    public void accept(Visitor visitor) {
        if (visitor.stmtVisitor != null) {
            visitor.stmtVisitor.visitSwitchStatement(this);
        } else {
            visitor.visitSwitchStmt(this);
        }
    }

    public void traverse(Visitor visitor) {
        this.condition.action(visitor);
        this.body.action(visitor);
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        if (this.condition == oldObj) {
            this.condition = (ParExpr)newObj;
            return true;
        }
        return AstVector.replace(this.body, oldObj, newObj);
    }

    public JavaToken leftToken() {
        return this.switchToken;
    }

    public JavaToken rightToken() {
        return this.rightBrace;
    }
}

