/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstCaseLabel;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstStatement;
import com.togethersoft.sca.ast.AstSwitchGroup;
import com.togethersoft.sca.internal.jparser.ast.Ast;
import com.togethersoft.sca.internal.jparser.ast.AstVector;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.Stmt;
import com.togethersoft.sca.internal.jparser.ast.Visitor;

public class SwitchGroup
extends Stmt
implements AstSwitchGroup {
    AstVector caseLabels;
    AstVector statements;
    AstCaseLabel defaultLabel;

    public SwitchGroup(AstVector labels, AstVector statements, AstCaseLabel defaultLabel) {
        this.caseLabels = labels;
        this.statements = statements;
        this.defaultLabel = defaultLabel;
        labels.setParent(this);
        if (statements != null) {
            statements.setParent(this);
        }
    }

    public int astType() {
        return 54;
    }

    public int getObjectKind() {
        return 26;
    }

    public AstObject[] getChildren() {
        int nLabels = this.numCaseLabels();
        int nStmts = this.numStatements();
        AstObject[] arr = new AstObject[nLabels + nStmts];
        int idx = 0;
        int i = 0;
        while (i < nLabels) {
            arr[idx++] = this.getCaseLabel(i);
            ++i;
        }
        int i2 = 0;
        while (i2 < nStmts) {
            arr[idx++] = this.getStatement(i2);
            ++i2;
        }
        return arr;
    }

    public AstCaseLabel[] getLabels() {
        return this.caseLabels.toArray(new AstCaseLabel[this.caseLabels.size()]);
    }

    public AstStatement[] getStatements() {
        if (this.statements == null) {
            return new AstStatement[0];
        }
        return this.statements.toArray(new AstStatement[this.statements.size()]);
    }

    public AstCaseLabel getDefaultLabel() {
        return this.defaultLabel;
    }

    public void addStatement(AstStatement stmt) {
        if (this.statements == null) {
            this.statements = new AstVector();
        } else if (this.statements.size() > 0) {
            Stmt lastStmt = (Stmt)this.statements.get(this.statements.size() - 1);
            ((Stmt)stmt).leftToken().setPosition(lastStmt.getStartColumn(), lastStmt.getEndLine());
        }
        this.statements.add(stmt);
    }

    public int numCaseLabels() {
        return this.caseLabels.size();
    }

    public Ast getCaseLabel(int i) {
        return this.caseLabels.at(i);
    }

    public int numStatements() {
        return this.statements != null ? this.statements.size() : 0;
    }

    public Stmt getStatement(int i) {
        return (Stmt)this.statements.get(i);
    }

    public void accept(Visitor visitor) {
        visitor.visitSwitchGroup(this);
    }

    public void traverse(Visitor visitor) {
        this.caseLabels.action(visitor);
        if (this.statements != null) {
            this.statements.action(visitor);
        }
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        return AstVector.replace(this.caseLabels, oldObj, newObj) || AstVector.replace(this.statements, oldObj, newObj);
    }

    public JavaToken leftToken() {
        return this.caseLabels.at(0).leftToken();
    }

    public JavaToken rightToken() {
        if (this.numStatements() > 0) {
            return this.getStatement(this.numStatements() - 1).rightToken();
        }
        return this.caseLabels.at(this.caseLabels.size() - 1).rightToken();
    }
}

