/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstConstructorInvocation;
import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.internal.jparser.ast.AstVector;
import com.togethersoft.sca.internal.jparser.ast.Expr;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.SuperExpr;
import com.togethersoft.sca.internal.jparser.ast.Visitor;

public class SuperCall
extends Expr
implements AstConstructorInvocation {
    private Expr base;
    public JavaToken dotToken;
    public SuperExpr superKeyword;
    public JavaToken leftParen;
    private AstVector arguments;
    public JavaToken rightParen;
    public AstDeclaration ctor;

    public SuperCall(Expr base, JavaToken dotToken, SuperExpr superKeyword, JavaToken leftParen, AstVector arguments, JavaToken rightParen) {
        this.base = base;
        this.dotToken = dotToken;
        this.superKeyword = superKeyword;
        this.leftParen = leftParen;
        this.arguments = arguments;
        this.rightParen = rightParen;
        superKeyword.setParent(this);
        if (base != null) {
            base.setParent(this);
        }
        if (arguments != null) {
            arguments.setParent(this);
        }
    }

    public int astType() {
        return 30;
    }

    public int getObjectKind() {
        return 29;
    }

    public AstExpression[] getOperands() {
        return this.toExprArray(this.base, this.arguments);
    }

    public boolean isSuperCall() {
        return true;
    }

    public boolean isThisCall() {
        return false;
    }

    public AstExpression getBase() {
        return this.base;
    }

    public AstExpression[] getArguments() {
        return this.toExprArray(this.arguments);
    }

    public AstDeclaration getReferencedElement() {
        return this.ctor;
    }

    public Expr base() {
        return this.base;
    }

    public int numArguments() {
        return this.arguments == null ? 0 : this.arguments.size();
    }

    public Expr argument(int i) {
        return (Expr)this.arguments.get(i);
    }

    public AstVector getArgumentsVector() {
        return this.arguments;
    }

    public void accept(Visitor visitor) {
        if (visitor.exprVisitor != null) {
            visitor.exprVisitor.visitConstructorInvocation(this);
        } else {
            visitor.visitSuperCall(this);
        }
    }

    public void traverse(Visitor visitor) {
        if (this.base != null) {
            this.base.action(visitor);
        }
        if (this.arguments != null) {
            this.arguments.action(visitor);
        }
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        if (this.base == oldObj) {
            this.base = (Expr)oldObj;
            return true;
        }
        return AstVector.replace(this.arguments, oldObj, newObj);
    }

    public JavaToken leftToken() {
        return this.base != null ? this.base.leftToken() : this.superKeyword.leftToken();
    }

    public JavaToken rightToken() {
        return this.rightParen;
    }
}

