/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstStatement;
import com.togethersoft.sca.internal.jparser.ast.Ast;
import com.togethersoft.sca.internal.jparser.ast.SimpleName;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public abstract class Stmt
extends Ast
implements AstStatement {
    protected static final AstStatement[] EMPTY_STATEMENT_SET = new AstStatement[0];
    protected static final String[] EMPTY_LABEL_SET = new String[0];
    private ArrayList labels;

    public String[] getLabelNames() {
        if (this.labels == null) {
            return EMPTY_LABEL_SET;
        }
        int i = 0;
        String[] arrLabels = new String[this.labels.size()];
        Iterator iter = ((AbstractList)this.labels).iterator();
        while (iter.hasNext()) {
            SimpleName l = (SimpleName)iter.next();
            arrLabels[i++] = l.getName();
        }
        return arrLabels;
    }

    public void addLabel(SimpleName label) {
        if (this.labels == null) {
            this.labels = new ArrayList(1);
        }
        this.labels.add(label);
    }

    public int numLabels() {
        return this.labels != null ? this.labels.size() : 0;
    }

    public SimpleName label(int i) {
        return (SimpleName)this.labels.get(i);
    }

    public SimpleName lookupLabel(String label) {
        if (this.labels != null) {
            Iterator iter = ((AbstractList)this.labels).iterator();
            while (iter.hasNext()) {
                SimpleName l = (SimpleName)iter.next();
                if (!l.getName().equals(label)) continue;
                return l;
            }
        }
        return null;
    }

    public boolean isLabeled() {
        return this.labels != null;
    }

    public boolean isBreakable() {
        return this.astType() == 43 || this.astType() == 42 || this.astType() == 44 || this.astType() == 53;
    }

    public boolean isContinuable() {
        return this.astType() == 43 || this.astType() == 42 || this.astType() == 44;
    }

    protected AstStatement[] toStmtArray(Collection c) {
        if (c == null) {
            return EMPTY_STATEMENT_SET;
        }
        return c.toArray(new AstStatement[c.size()]);
    }
}

