/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstReturnStatement;
import com.togethersoft.sca.internal.jparser.ast.Ast;
import com.togethersoft.sca.internal.jparser.ast.Expr;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.Stmt;
import com.togethersoft.sca.internal.jparser.ast.Visitor;

public class ReturnStmt
extends Stmt
implements AstReturnStatement {
    private JavaToken returnToken;
    private Expr expr;
    private JavaToken semiToken;

    public ReturnStmt(JavaToken returnToken, Expr expr, JavaToken semiToken) {
        this.returnToken = returnToken;
        this.expr = expr;
        this.semiToken = semiToken;
        if (expr != null) {
            expr.setParent(this);
        }
    }

    public int astType() {
        return 55;
    }

    public int getObjectKind() {
        return 14;
    }

    public AstObject[] getChildren() {
        if (this.expr != null) {
            return new AstObject[]{this.expr};
        }
        return Ast.EMPTY_NODE_SET;
    }

    public AstExpression getReturnExpression() {
        return this.expr;
    }

    public Expr expr() {
        return this.expr;
    }

    public void accept(Visitor visitor) {
        if (visitor.stmtVisitor != null) {
            visitor.stmtVisitor.visitReturnStatement(this);
        } else {
            visitor.visitReturnStmt(this);
        }
    }

    public void traverse(Visitor visitor) {
        if (this.expr != null) {
            this.expr.action(visitor);
        }
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        if (this.expr == oldObj) {
            this.expr = (Expr)newObj;
            return true;
        }
        return false;
    }

    public JavaToken leftToken() {
        return this.returnToken;
    }

    public JavaToken rightToken() {
        return this.semiToken;
    }
}

