/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstParenthesizedExpression;
import com.togethersoft.sca.internal.jparser.ast.Expr;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.Visitor;

public class ParExpr
extends Expr
implements AstParenthesizedExpression {
    private JavaToken leftParen;
    private Expr expr;
    private JavaToken rightParen;

    public ParExpr(JavaToken leftParen, Expr expr, JavaToken rightParen) {
        this.leftParen = leftParen;
        this.expr = expr;
        this.rightParen = rightParen;
        expr.setParent(this);
    }

    public int astType() {
        return 46;
    }

    public int getObjectKind() {
        return 46;
    }

    public AstExpression[] getOperands() {
        return new AstExpression[]{this.expr};
    }

    public AstExpression getExpression() {
        return this.expr;
    }

    public Expr expr() {
        return this.expr;
    }

    public void accept(Visitor visitor) {
        if (visitor.exprVisitor != null) {
            visitor.exprVisitor.visitParenthesizedExpression(this);
        } else {
            visitor.visitParExpr(this);
        }
    }

    public void traverse(Visitor visitor) {
        this.expr.action(visitor);
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        if (this.expr == oldObj) {
            this.expr = (Expr)newObj;
            return true;
        }
        return false;
    }

    public JavaToken leftToken() {
        return this.leftParen;
    }

    public JavaToken rightToken() {
        return this.rightParen;
    }
}

