/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstClassFile;
import com.togethersoft.sca.ast.AstCompilationUnit;
import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstPackage;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.internal.jparser.ast.AstVector;
import com.togethersoft.sca.internal.jparser.ast.ClassFile;
import com.togethersoft.sca.internal.jparser.ast.CompilationUnit;
import com.togethersoft.sca.internal.jparser.ast.Declaration;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.Model;
import com.togethersoft.sca.internal.jparser.ast.TypeDeclaration;
import com.togethersoft.sca.internal.jparser.ast.Visitor;
import com.togethersoft.sca.internal.jparser.symbol.CDefinition;
import com.togethersoft.sca.internal.jparser.symbol.CPackage;

public class PackageDeclaration
extends Declaration
implements AstPackage {
    String pkg;
    public CPackage symbol;
    boolean isDefault;
    AstVector subpackages;
    AstVector cunits;
    AstVector classFiles;
    private Model model;

    public PackageDeclaration(Model model, String pkg) {
        super(null);
        this.model = model;
        this.pkg = pkg;
        this.isDefault = false;
    }

    public PackageDeclaration(Model model) {
        super(null);
        this.model = model;
        this.pkg = "";
        this.isDefault = true;
    }

    public int astType() {
        return 21;
    }

    public int getObjectKind() {
        return 7;
    }

    public AstObject[] getChildren() {
        int nPackages = this.numSubpackages();
        int nCunits = this.numCunits();
        int nClassFiles = this.numClassFiles();
        AstObject[] arr = new AstObject[nPackages + nCunits + nClassFiles];
        int idx = 0;
        int i = 0;
        while (i < nPackages) {
            arr[idx++] = this.getSubpackage(i);
            ++i;
        }
        int i2 = 0;
        while (i2 < nCunits) {
            arr[idx++] = this.getCunit(i2);
            ++i2;
        }
        int i3 = 0;
        while (i3 < nClassFiles) {
            arr[idx++] = this.getClassFile(i3);
            ++i3;
        }
        return arr;
    }

    public String getElementName() {
        return this.pkg;
    }

    public String getQualifiedName() {
        return this.symbol.getQualifiedName();
    }

    public boolean isDefaultPackage() {
        return this.isDefault;
    }

    public AstPackage[] getSubpackages() {
        if (this.subpackages == null) {
            return new AstPackage[0];
        }
        AstPackage[] arrSubpackages = new AstPackage[this.subpackages.size()];
        this.subpackages.toArray(arrSubpackages);
        return arrSubpackages;
    }

    public AstCompilationUnit[] getCompilationUnits() {
        if (this.cunits == null) {
            return new AstCompilationUnit[0];
        }
        AstCompilationUnit[] arrCunits = new AstCompilationUnit[this.cunits.size()];
        this.cunits.toArray(arrCunits);
        return arrCunits;
    }

    public AstClassFile[] getClassFiles() {
        if (this.classFiles == null) {
            return new AstClassFile[0];
        }
        return this.classFiles.toArray(new AstClassFile[this.classFiles.size()]);
    }

    public AstType findType(String name) {
        return this.lookupType(name);
    }

    public AstPackage findPackage(String name) {
        return this.lookupSubpackage(name);
    }

    public Model getModel() {
        return this.model;
    }

    public CDefinition getSymbol() {
        return this.symbol;
    }

    AstDeclaration[] getDeclarations() {
        return new AstDeclaration[]{this};
    }

    public int numSubpackages() {
        return this.subpackages == null ? 0 : this.subpackages.size();
    }

    public void addSubpackage(PackageDeclaration pkg) {
        if (this.subpackages == null) {
            this.subpackages = new AstVector();
        }
        this.subpackages.add(pkg);
        pkg.setParent(this);
    }

    public PackageDeclaration getSubpackage(int i) {
        return (PackageDeclaration)this.subpackages.get(i);
    }

    public PackageDeclaration lookupSubpackage(String name) {
        int i = 0;
        while (i < this.numSubpackages()) {
            if (name.equals(this.getSubpackage(i).getElementName())) {
                return this.getSubpackage(i);
            }
            ++i;
        }
        return null;
    }

    public PackageDeclaration insertSubpackage(String name) {
        PackageDeclaration pkg = new PackageDeclaration(this.model, name);
        this.addSubpackage(pkg);
        return pkg;
    }

    public PackageDeclaration lookupInsertSubpackage(String name) {
        PackageDeclaration pkg = this.lookupSubpackage(name);
        if (pkg != null) {
            return pkg;
        }
        return this.insertSubpackage(name);
    }

    public int numCunits() {
        return this.cunits == null ? 0 : this.cunits.size();
    }

    public void addCunit(CompilationUnit cu) {
        if (this.cunits == null) {
            this.cunits = new AstVector();
        }
        this.cunits.add(cu);
    }

    public CompilationUnit getCunit(int i) {
        return (CompilationUnit)this.cunits.get(i);
    }

    public void removeCunit(CompilationUnit cu) {
        if (this.cunits == null) {
            return;
        }
        int index = this.cunits.indexOf(cu);
        if (index < 0) {
            return;
        }
        this.cunits.remove(index);
    }

    public int numClassFiles() {
        return this.classFiles == null ? 0 : this.classFiles.size();
    }

    public void addClassFile(ClassFile file) {
        if (this.classFiles == null) {
            this.classFiles = new AstVector();
        }
        this.classFiles.add(file);
        file.setParent(this);
    }

    public ClassFile getClassFile(int i) {
        return (ClassFile)this.classFiles.get(i);
    }

    public TypeDeclaration lookupType(String name) {
        int i = 0;
        while (i < this.numCunits()) {
            TypeDeclaration type = this.getCunit(i).findType(name);
            if (type != null) {
                return type;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.numClassFiles()) {
            if (name.equals(this.getClassFile(i2).getType().getElementName())) {
                return this.getClassFile(i2).getTypeDecl();
            }
            ++i2;
        }
        return null;
    }

    public void accept(Visitor visitor) {
        visitor.visitPackageDeclaration(this);
    }

    public void traverse(Visitor visitor) {
        if (this.subpackages != null) {
            this.subpackages.action(visitor);
        }
        if (this.cunits != null) {
            this.cunits.action(visitor);
        }
        if ((visitor.getAction() & 8) == 0 && this.classFiles != null) {
            this.classFiles.action(visitor);
        }
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        return AstVector.replace(this.subpackages, oldObj, newObj) || AstVector.replace(this.cunits, oldObj, newObj) || AstVector.replace(this.classFiles, oldObj, newObj);
    }

    public JavaToken leftToken() {
        return null;
    }

    public JavaToken rightToken() {
        return null;
    }
}

