/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstAssertStatement;
import com.togethersoft.sca.ast.AstAssignmentExpression;
import com.togethersoft.sca.ast.AstBreakStatement;
import com.togethersoft.sca.ast.AstCastExpression;
import com.togethersoft.sca.ast.AstComment;
import com.togethersoft.sca.ast.AstCompoundStatement;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstExpressionStatement;
import com.togethersoft.sca.ast.AstFieldReference;
import com.togethersoft.sca.ast.AstMethodCallExpression;
import com.togethersoft.sca.ast.AstObjectFactory;
import com.togethersoft.sca.ast.AstParenthesizedExpression;
import com.togethersoft.sca.ast.AstSimpleReference;
import com.togethersoft.sca.ast.AstStatement;
import com.togethersoft.sca.ast.AstSuperExpression;
import com.togethersoft.sca.ast.AstThisExpression;
import com.togethersoft.sca.ast.AstTypeExpression;
import com.togethersoft.sca.internal.jparser.ast.AssertStmt;
import com.togethersoft.sca.internal.jparser.ast.AssignExpr;
import com.togethersoft.sca.internal.jparser.ast.Ast;
import com.togethersoft.sca.internal.jparser.ast.AstVector;
import com.togethersoft.sca.internal.jparser.ast.Block;
import com.togethersoft.sca.internal.jparser.ast.BreakStmt;
import com.togethersoft.sca.internal.jparser.ast.CastExpr;
import com.togethersoft.sca.internal.jparser.ast.Comment;
import com.togethersoft.sca.internal.jparser.ast.Expr;
import com.togethersoft.sca.internal.jparser.ast.ExprStmt;
import com.togethersoft.sca.internal.jparser.ast.FieldAccess;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.MethodCall;
import com.togethersoft.sca.internal.jparser.ast.ParExpr;
import com.togethersoft.sca.internal.jparser.ast.SimpleName;
import com.togethersoft.sca.internal.jparser.ast.Stmt;
import com.togethersoft.sca.internal.jparser.ast.SuperExpr;
import com.togethersoft.sca.internal.jparser.ast.ThisExpr;
import com.togethersoft.sca.internal.jparser.ast.TypeExpr;

public class ObjectFactory
implements AstObjectFactory {
    static final int FIX = 44;
    static final String[] letOpMnem = new String[]{"=", "+=", "-=", "*=", "/=", "%=", ">>=", ">>>=", "<<=", "&=", "^=", "|="};
    public static final ObjectFactory instance = new ObjectFactory();

    public AstExpressionStatement createAstExpressionStatement(AstExpression expression) {
        return new ExprStmt((Expr)expression, new JavaToken(44, ";"));
    }

    public AstAssertStatement createAstAssertStatement(AstExpression condition, AstExpression argument) {
        return new AssertStmt(new JavaToken(44, "assert"), (Expr)condition, argument != null ? new JavaToken(44, ":") : null, (Expr)argument, new JavaToken(44, ";"));
    }

    public AstBreakStatement createAstBreakStatement() {
        return new BreakStmt(new JavaToken(44, "break"), null, new JavaToken(44, ";"));
    }

    public AstCastExpression createAstCastExpression(AstTypeExpression typeSpec, AstExpression expr) {
        return new CastExpr(new JavaToken(44, "("), (TypeExpr)typeSpec, new JavaToken(44, ")"), (Expr)expr);
    }

    public AstComment createAstComment(String comment) {
        return new Comment(new JavaToken(44, comment), false, true);
    }

    public AstFieldReference createAstFieldReference(AstExpression base, int kind, String ident) {
        return new FieldAccess((Expr)base, kind, new JavaToken(44, "."), new JavaToken(44, ident));
    }

    public AstMethodCallExpression createAstMethodCallExpression(AstExpression base, AstExpression[] arguments) {
        AstVector vector = new AstVector();
        int i = 0;
        while (i < arguments.length) {
            vector.add(arguments[i]);
            ++i;
        }
        return new MethodCall((Expr)base, new JavaToken(44, "("), vector, new JavaToken(44, ")"));
    }

    public AstParenthesizedExpression createAstParenthesizedExpression(AstExpression expr) {
        return new ParExpr(new JavaToken(44, "("), (Expr)expr, new JavaToken(44, ")"));
    }

    public AstSimpleReference createAstSimpleReference(String name) {
        return new SimpleName(new JavaToken(44, name));
    }

    public AstThisExpression createAstThisExpression() {
        return new ThisExpr(new JavaToken(44, "this"));
    }

    public AstSuperExpression createAstSuperExpression() {
        return new SuperExpr(new JavaToken(44, "super"));
    }

    public AstTypeExpression createAstTypeExpression(String typeName) {
        return new TypeExpr(new SimpleName(new JavaToken(44, typeName)));
    }

    public AstCompoundStatement createAstCompoundStatement(AstStatement[] stmts, AstStatement parent) {
        Stmt[] blockStmts = new Stmt[stmts.length];
        System.arraycopy(stmts, 0, blockStmts, 0, stmts.length);
        JavaToken last = new JavaToken(44, "}");
        int i = 0;
        while (i < stmts.length) {
            JavaToken firstStmtToken = blockStmts[i].leftToken();
            firstStmtToken.setType(44);
            firstStmtToken.setColumn(parent.getPosition().getStartColumn() + 4);
            last.setPosition(firstStmtToken);
            ++i;
        }
        last.setColumn(((Ast)((Object)parent)).leftToken().getColumn());
        last.setType(75);
        return new Block(new JavaToken(44, "{"), blockStmts, last);
    }

    public AstAssignmentExpression createAstAssignmentExpression(int kind, AstExpression dst, AstExpression src) {
        return new AssignExpr(kind, (Expr)dst, new JavaToken(44, letOpMnem[kind]), (Expr)src);
    }
}

