/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstObjectCreationExpression;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.internal.jparser.ast.AstVector;
import com.togethersoft.sca.internal.jparser.ast.Expr;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.Name;
import com.togethersoft.sca.internal.jparser.ast.TypeDeclaration;
import com.togethersoft.sca.internal.jparser.ast.Visitor;

public class NewExpr
extends Expr
implements AstObjectCreationExpression {
    public Expr base;
    public Name typeSpec;
    public JavaToken newToken;
    public JavaToken leftParen;
    AstVector args;
    public JavaToken rightParen;
    public TypeDeclaration classBody;
    public AstDeclaration ctor;

    public NewExpr(Expr base, Name typeSpec, JavaToken newToken, JavaToken leftParen, AstVector args, JavaToken rightParen, TypeDeclaration classBody) {
        this.base = base;
        this.typeSpec = typeSpec;
        this.newToken = newToken;
        this.leftParen = leftParen;
        this.args = args;
        this.rightParen = rightParen;
        this.classBody = classBody;
        typeSpec.setParent(this);
        if (base != null) {
            base.setParent(this);
        }
        if (args != null) {
            args.setParent(this);
        }
        if (classBody != null) {
            classBody.setParent(this);
        }
    }

    public int astType() {
        return 20;
    }

    public int getObjectKind() {
        return 39;
    }

    public AstObject[] getChildren() {
        AstObject[] opnds = this.getOperands();
        if (this.classBody != null) {
            AstObject[] arr = new AstObject[opnds.length + 1];
            System.arraycopy(opnds, 0, arr, 0, opnds.length);
            arr[arr.length - 1] = this.classBody;
            return arr;
        }
        return opnds;
    }

    public AstExpression[] getOperands() {
        return this.toExprArray(this.base, this.args);
    }

    public AstExpression getBase() {
        return this.base;
    }

    public AstType getObjectType() {
        if (this.type() != null && this.type().getAST() instanceof AstType) {
            return (AstType)((Object)this.type().getAST());
        }
        return null;
    }

    public AstExpression[] getArguments() {
        return this.toExprArray(this.args);
    }

    public AstType getClassBody() {
        return this.classBody;
    }

    public AstDeclaration getReferencedElement() {
        return this.ctor;
    }

    public int numArguments() {
        return this.args == null ? 0 : this.args.size();
    }

    public Expr argument(int i) {
        return (Expr)this.args.get(i);
    }

    public AstVector getArgumentsVector() {
        return this.args;
    }

    public TypeDeclaration body() {
        return this.classBody;
    }

    public void accept(Visitor visitor) {
        if (visitor.exprVisitor != null) {
            visitor.exprVisitor.visitObjectCreationExpression(this);
        } else {
            visitor.visitNewExpr(this);
        }
    }

    public void traverse(Visitor visitor) {
        if (!visitor.isExternal()) {
            this.typeSpec.action(visitor);
        }
        if (this.base != null) {
            this.base.action(visitor);
        }
        if (this.args != null) {
            this.args.action(visitor);
        }
        if (this.classBody != null) {
            this.classBody.action(visitor);
        }
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        if (this.typeSpec == oldObj) {
            this.typeSpec = (Name)newObj;
        } else if (this.base == oldObj) {
            this.base = (Expr)newObj;
        } else if (this.classBody == oldObj) {
            this.classBody = (TypeDeclaration)newObj;
        } else {
            return AstVector.replace(this.args, oldObj, newObj);
        }
        return true;
    }

    public JavaToken leftToken() {
        return this.base != null ? this.base.leftToken() : this.newToken;
    }

    public JavaToken rightToken() {
        return this.classBody != null ? this.classBody.rightToken() : this.rightParen;
    }
}

