/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstModifiers;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.internal.jparser.ast.Ast;
import com.togethersoft.sca.internal.jparser.ast.AstVector;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.Modifier;
import com.togethersoft.sca.internal.jparser.ast.Visitor;

public class Modifiers
extends Ast
implements AstModifiers {
    int mods = 0;
    AstVector modsVector;
    private static final String[] modifierName = new String[]{"public", "private", "protected", "static", "final", "synchronized", "volatile", "transient", "native", "interface", "abstract", "structfp"};

    public Modifiers() {
    }

    public Modifiers(int mods) {
        this.mods = mods;
    }

    public int astType() {
        return 18;
    }

    public int getObjectKind() {
        return 0;
    }

    public AstObject[] getChildren() {
        return Ast.EMPTY_NODE_SET;
    }

    public int numModifiers() {
        return this.modsVector == null ? 0 : this.modsVector.size();
    }

    public Modifier modifier(int i) {
        return (Modifier)this.modsVector.get(i);
    }

    public void addModifier(Modifier m) {
        if (this.modsVector == null) {
            this.modsVector = new AstVector(1);
        }
        this.mods |= m.kind();
        this.modsVector.add(m);
        m.setParent(this);
    }

    public void setModifiers(int mods) {
        int diff = this.mods ^ mods;
        JavaToken left = this.leftToken();
        if (left == null && this.parent != null) {
            left = this.parent.leftToken();
        }
        int bit = 0;
        while (diff != 0) {
            if ((diff & 1) != 0) {
                if ((1 << bit & mods) != 0) {
                    this.insertModifier(bit);
                } else {
                    this.deleteModifier(bit);
                }
            }
            diff >>>= 1;
            ++bit;
        }
        this.mods = mods;
        JavaToken newLeft = this.leftToken();
        if (newLeft != null && left != null && left != newLeft) {
            newLeft.setComments(left.getComments());
            left.setComments(null);
        }
    }

    private void insertModifier(int bit) {
        Modifier prev = null;
        if (this.modsVector == null) {
            this.modsVector = new AstVector(1);
        } else if (this.modsVector.size() > 0) {
            prev = (Modifier)this.modsVector.get(this.modsVector.size() - 1);
        }
        JavaToken newModifier = new JavaToken(modifierName[bit]);
        if (prev != null) {
            JavaToken prevToken = prev.modToken;
            newModifier.setLine(prevToken.getLine());
            newModifier.setColumn(prevToken.getColumn() + prevToken.getText().length() + 1);
        } else if (this.parent != null) {
            newModifier.setPosition(this.parent.leftToken());
        }
        this.modsVector.add(new Modifier(1 << bit, newModifier));
    }

    private void deleteModifier(int bit) {
        int i = 0;
        while (i < this.numModifiers()) {
            Modifier m = this.modifier(i);
            if (m.kind() == 1 << bit) {
                m.setDeleted();
                break;
            }
            ++i;
        }
    }

    public void accept(Visitor visitor) {
        visitor.visitModifiers(this);
    }

    public void traverse(Visitor visitor) {
        if (this.modsVector != null) {
            this.modsVector.action(visitor);
        }
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        return AstVector.replace(this.modsVector, oldObj, newObj);
    }

    public JavaToken leftToken() {
        if (this.modsVector != null && this.modsVector.size() > 0) {
            return ((Modifier)this.modsVector.get(0)).leftToken();
        }
        return null;
    }

    public JavaToken rightToken() {
        if (this.modsVector != null && this.modsVector.size() > 0) {
            return ((Modifier)this.modsVector.get(this.modsVector.size() - 1)).rightToken();
        }
        return null;
    }
}

