/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstCompilationUnit;
import com.togethersoft.sca.ast.AstModel;
import com.togethersoft.sca.ast.AstModelChangeListener;
import com.togethersoft.sca.ast.AstModelDelta;
import com.togethersoft.sca.ast.AstPackage;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.internal.jparser.Control;
import com.togethersoft.sca.internal.jparser.ast.ClassFile;
import com.togethersoft.sca.internal.jparser.ast.CompilationUnit;
import com.togethersoft.sca.internal.jparser.ast.Name;
import com.togethersoft.sca.internal.jparser.ast.PackageDeclaration;
import com.togethersoft.sca.internal.jparser.ast.TypeDeclaration;
import com.togethersoft.sca.internal.jparser.ast.VariableDeclaration;
import com.togethersoft.sca.internal.jparser.ast.writer.AstWriter;
import com.togethersoft.sca.internal.jparser.ast.writer.FormatWriter;
import com.togethersoft.sca.internal.jparser.symbol.CCompilationUnit;
import com.togethersoft.sca.internal.jparser.symbol.CPackage;
import com.togethersoft.sca.internal.jparser.symbol.CScope;
import com.togethersoft.sca.internal.jparser.symbol.CTopLevel;
import com.togethersoft.sca.internal.jparser.symbol.ErrorMgr;
import com.togethersoft.sca.internal.jparser.symbol.Semantic;
import com.togethersoft.sca.internal.jparser.symbol.SymbolReader;
import com.togethersoft.sca.internal.jparser.symbol.SymbolWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class Model
implements AstModel {
    private ArrayList packages;
    private PackageDeclaration defaultPackage;
    private ArrayList pendingCunits = new ArrayList();
    private HashMap sourceFiles;
    private LinkedList listeners = new LinkedList();
    private Semantic sem;
    private CTopLevel symbolTable;
    private Control compiler;

    public Model(Control compiler) {
        this.compiler = compiler;
        this.sem = new Semantic(this, true);
        this.symbolTable = this.sem.topContext;
        this.packages = new ArrayList();
        this.defaultPackage = new PackageDeclaration(this);
        this.defaultPackage.symbol = this.symbolTable.getDefaultPackage();
        this.symbolTable.getDefaultPackage().astNode = this.defaultPackage;
        this.packages.add(this.defaultPackage);
        this.sourceFiles = new HashMap();
        this.symbolTable.initialize();
    }

    public Model(Control compiler, ObjectInputStream s) throws IOException, ClassNotFoundException, RuntimeException {
        this.compiler = compiler;
        this.sem = new Semantic(this, false);
        this.symbolTable = (CTopLevel)s.readObject();
        this.sem.setSymbolTable(this.symbolTable);
        this.packages = (ArrayList)s.readObject();
        this.defaultPackage = (PackageDeclaration)s.readObject();
        this.sourceFiles = (HashMap)s.readObject();
        SymbolReader symReader = new SymbolReader(s);
        symReader.traverse(this.symbolTable);
    }

    public Control getCompiler() {
        return this.compiler;
    }

    public Semantic getSemantic() {
        return this.sem;
    }

    public void store(ObjectOutputStream s) throws IOException, RuntimeException {
        s.writeObject(this.symbolTable);
        s.writeObject(this.packages);
        s.writeObject(this.defaultPackage);
        s.writeObject(this.sourceFiles);
        SymbolWriter symWriter = new SymbolWriter(s);
        symWriter.traverse(this.symbolTable);
    }

    public void print() throws IOException {
        int i = 0;
        while (i < this.numPackages()) {
            this.print(this.getPackage(i));
            ++i;
        }
    }

    private void print(PackageDeclaration pkg) throws IOException {
        int i = 0;
        while (i < pkg.numSubpackages()) {
            this.print(pkg.getSubpackage(i));
            ++i;
        }
        AstCompilationUnit[] files = pkg.getCompilationUnits();
        int i2 = 0;
        while (i2 < files.length) {
            FileOutputStream stream = new FileOutputStream(files[i2].getElementName() + ".fix");
            FormatWriter out = new FormatWriter(stream);
            new AstWriter().writeFile(out, (CompilationUnit)files[i2]);
            out.close();
            ++i2;
        }
    }

    public AstPackage[] getPackages() {
        AstPackage[] arrPackages = new AstPackage[this.packages.size()];
        this.packages.toArray(arrPackages);
        return arrPackages;
    }

    public AstPackage getDefaultPackage() {
        return this.defaultPackage;
    }

    public AstPackage findPackage(String name) {
        CScope symbol = this.symbolTable.lookupPackageOrType(name);
        if (symbol != null && symbol.getAST() instanceof AstPackage) {
            return (AstPackage)((Object)symbol.getAST());
        }
        return null;
    }

    public AstType findType(String name) {
        CScope symbol = this.symbolTable.lookupPackageOrType(name);
        if (symbol != null && symbol.getAST() instanceof AstType) {
            return (AstType)((Object)symbol.getAST());
        }
        return null;
    }

    public boolean canContinue() {
        return this.compiler.canContinue();
    }

    public int numPackages() {
        return this.packages.size();
    }

    public PackageDeclaration getPackage(int i) {
        return (PackageDeclaration)this.packages.get(i);
    }

    private PackageDeclaration lookupPackage(String packageName) {
        int i = 0;
        while (i < this.numPackages()) {
            if (this.getPackage(i).getElementName().equals(packageName)) {
                return this.getPackage(i);
            }
            ++i;
        }
        return null;
    }

    public PackageDeclaration lookupInsertPackage(String name) {
        PackageDeclaration pkg = this.lookupPackage(name);
        if (pkg == null) {
            pkg = new PackageDeclaration(this, name);
            CPackage symbol = this.symbolTable.insertPackage(name);
            symbol.astNode = pkg;
            pkg.symbol = symbol;
            this.packages.add(pkg);
        }
        return pkg;
    }

    private PackageDeclaration lookupInsertPackage(Name id) {
        if (id.base() == null) {
            return this.lookupInsertPackage(id.getName());
        }
        PackageDeclaration ownerPackage = this.lookupInsertPackage((Name)id.base());
        return this.lookupInsertPackage(ownerPackage, id.getName());
    }

    public PackageDeclaration lookupInsertPackage(PackageDeclaration ownerPackage, String name) {
        PackageDeclaration pkg = ownerPackage.lookupSubpackage(name);
        if (pkg == null) {
            pkg = ownerPackage.insertSubpackage(name);
            CPackage symbol = ownerPackage.symbol.insertPackage(name);
            symbol.astNode = pkg;
            pkg.symbol = symbol;
        }
        return pkg;
    }

    public PackageDeclaration lookupInsertPackageQualified(String qualifiedName) {
        PackageDeclaration pkg = null;
        StringTokenizer st = new StringTokenizer(qualifiedName, "/");
        while (st.hasMoreTokens()) {
            PackageDeclaration subPkg;
            String pkgName = st.nextToken();
            pkg = pkg == null ? this.lookupInsertPackage(pkgName) : (subPkg = this.lookupInsertPackage(pkg, pkgName));
        }
        return pkg;
    }

    public boolean enqueueFile(CompilationUnit cu) {
        PackageDeclaration ownerPackage = cu.getPackageName() == null ? (PackageDeclaration)this.getDefaultPackage() : this.lookupInsertPackage(cu.getPackageName());
        if (this.lookupSourceFile(cu.getFilename()) != null) {
            ErrorMgr.report(32, cu.getElementName());
            return false;
        }
        this.sourceFiles.put(cu.getFilename(), cu);
        ownerPackage.addCunit(cu);
        cu.setParent(ownerPackage);
        this.pendingCunits.add(cu);
        this.sem.processTypes(cu, ownerPackage.symbol);
        return true;
    }

    public void processPendingDeclarations() {
        this.symbolTable.initLibraryTypes(this.compiler.isAssertEnabled());
        int i = 0;
        while (i < this.pendingCunits.size()) {
            if (!this.canContinue()) {
                return;
            }
            this.sem.processImports((CompilationUnit)this.pendingCunits.get(i));
            ++i;
        }
        int i2 = 0;
        while (i2 < this.pendingCunits.size()) {
            if (!this.canContinue()) {
                return;
            }
            this.sem.processSuperTypes((CompilationUnit)this.pendingCunits.get(i2));
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.pendingCunits.size()) {
            if (!this.canContinue()) {
                return;
            }
            this.sem.processMembers((CompilationUnit)this.pendingCunits.get(i3));
            ++i3;
        }
    }

    public void processPendingBodies() {
        double delta = 0.0;
        int numFiles = this.pendingCunits.size();
        if (numFiles > 0) {
            delta = 1.0 / (double)numFiles;
        } else {
            this.compiler.updateJob(1.0);
        }
        int i = 0;
        while (i < numFiles) {
            if (!this.canContinue()) {
                return;
            }
            try {
                this.sem.processBodies((CompilationUnit)this.pendingCunits.get(i));
            }
            catch (Throwable e) {
                this.removeSourceFile((CompilationUnit)this.pendingCunits.get(i));
                this.compiler.logError("jparser.Control.8", new Object[]{e});
            }
            this.compiler.updateJob(delta);
            ++i;
        }
        this.pendingCunits.clear();
    }

    public void removePendingFiles() {
        int i = 0;
        while (i < this.pendingCunits.size()) {
            this.removeSourceFile((CompilationUnit)this.pendingCunits.get(i));
            ++i;
        }
        this.pendingCunits.clear();
    }

    public void report(PrintStream s, boolean showBinaryTypes) {
        this.sem.report(s, showBinaryTypes);
    }

    public CompilationUnit lookupSourceFile(String filename) {
        return (CompilationUnit)this.sourceFiles.get(filename);
    }

    public void removeSourceFile(CompilationUnit cu) {
        if (this.sourceFiles.remove(cu.getFilename()) == null) {
            return;
        }
        ((PackageDeclaration)cu.getPackage()).removeCunit(cu);
        CCompilationUnit symbol = cu.symbol;
        symbol.getPackage().removeCUnit(symbol);
    }

    public Collection getSourceFiles() {
        return this.sourceFiles.values();
    }

    public void addPackage(PackageDeclaration pkg) {
        PackageDeclaration ownerPackage = this.lookupPackage(pkg.getElementName());
        if (ownerPackage != null) {
            this.addPackage(ownerPackage, pkg);
            return;
        }
        this.packages.add(pkg);
    }

    private void addPackage(PackageDeclaration ownerPackage, PackageDeclaration pkg) {
        int i = 0;
        while (i < pkg.numSubpackages()) {
            PackageDeclaration newPkg = pkg.getSubpackage(i);
            PackageDeclaration oldPkg = ownerPackage.lookupSubpackage(newPkg.getElementName());
            if (oldPkg != null) {
                this.addPackage(oldPkg, newPkg);
            } else {
                ownerPackage.addSubpackage(newPkg);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < pkg.numCunits()) {
            CompilationUnit cu = pkg.getCunit(i2);
            if (this.lookupSourceFile(cu.getFilename()) != null) {
                ErrorMgr.report(32, cu.getElementName());
            } else {
                this.sourceFiles.put(cu.getFilename(), cu);
                ownerPackage.addCunit(cu);
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < pkg.numClassFiles()) {
            ClassFile file = pkg.getClassFile(i3);
            TypeDeclaration type = file.getTypeDecl();
            if (ownerPackage.lookupType(type.getElementName()) != null) {
                ErrorMgr.report(33, type.getElementName());
            } else {
                ownerPackage.addClassFile(file);
            }
            ++i3;
        }
    }

    void processSource(CompilationUnit oldCu) {
        CompilationUnit newCu = this.compiler.parseFile(oldCu.getFilename(), true);
        if (newCu == null) {
            return;
        }
        if (oldCu.numTypeDeclarations() != newCu.numTypeDeclarations()) {
            ErrorMgr.report(43, oldCu.getElementName());
            return;
        }
        oldCu.setSourcePending(newCu.sourcePending());
        int i = 0;
        while (i < newCu.numTypeDeclarations()) {
            this.processSource(newCu.getTypeDeclaration(i), oldCu.getTypeDeclaration(i));
            ++i;
        }
        this.sem.processBodies(oldCu);
    }

    private void processSource(TypeDeclaration newType, TypeDeclaration oldType) {
        if (newType.numMethods() != oldType.numMethods() || newType.numConstructors() != oldType.numConstructors() || newType.numClassInitializers() != oldType.numClassInitializers() || newType.numNestedTypes() != oldType.numNestedTypes()) {
            ErrorMgr.report(43, oldType.getQualifiedName());
            return;
        }
        int i = 0;
        while (i < newType.numFields()) {
            VariableDeclaration oldField = oldType.getField(i);
            VariableDeclaration newField = newType.getField(i);
            int j = 0;
            while (j < newField.numDeclarators()) {
                oldField.getDeclarator(j).setInitializer(newField.getDeclarator((int)j).initializer);
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < newType.numMethods()) {
            oldType.getMethod(i2).setBody(newType.getMethod((int)i2).body);
            ++i2;
        }
        int i3 = 0;
        while (i3 < newType.numConstructors()) {
            oldType.getConstructor(i3).setBody(newType.getConstructor((int)i3).body);
            ++i3;
        }
        int i4 = 0;
        while (i4 < newType.numClassInitializers()) {
            oldType.getClassInitializer(i4).setBody(newType.getClassInitializer((int)i4).body);
            ++i4;
        }
        int i5 = 0;
        while (i5 < newType.numNestedTypes()) {
            this.processSource(newType.getNestedType(i5), oldType.getNestedType(i5));
            ++i5;
        }
    }

    public void addModelChangeListener(AstModelChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeModelChangeListener(AstModelChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void broadastChanges(AstModelDelta delta) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            AstModelChangeListener element = (AstModelChangeListener)iter.next();
            element.modelChanged(delta);
        }
    }
}

