/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstCompoundStatement;
import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstReference;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.ast.AstTypeReference;
import com.togethersoft.sca.ast.AstVariable;
import com.togethersoft.sca.internal.jparser.ast.AstVector;
import com.togethersoft.sca.internal.jparser.ast.Block;
import com.togethersoft.sca.internal.jparser.ast.Brackets;
import com.togethersoft.sca.internal.jparser.ast.CompilationUnit;
import com.togethersoft.sca.internal.jparser.ast.Declaration;
import com.togethersoft.sca.internal.jparser.ast.FormalParameter;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.Modifiers;
import com.togethersoft.sca.internal.jparser.ast.PackageDeclaration;
import com.togethersoft.sca.internal.jparser.ast.Stmt;
import com.togethersoft.sca.internal.jparser.ast.ThrowSpecifier;
import com.togethersoft.sca.internal.jparser.ast.TypeDeclaration;
import com.togethersoft.sca.internal.jparser.ast.TypeExpr;
import com.togethersoft.sca.internal.jparser.ast.Visitor;
import com.togethersoft.sca.internal.jparser.dbc.CommentParser;
import com.togethersoft.sca.internal.jparser.symbol.CDefinition;
import com.togethersoft.sca.internal.jparser.symbol.CMethod;
import com.togethersoft.sca.internal.jparser.symbol.CTopLevel;
import java.util.HashSet;
import java.util.Iterator;

public class MethodDeclaration
extends Declaration
implements AstMethod,
AstReference {
    String name;
    public TypeExpr retType;
    public JavaToken nameToken;
    public JavaToken leftParen;
    FormalParameter[] params;
    public JavaToken rightParen;
    AstVector brackets;
    public JavaToken throwsToken;
    AstVector throwSpec;
    public transient Stmt body;
    private boolean hasSource;
    private boolean isConstructor;
    private transient AstExpression[] preconditions;
    private transient AstExpression[] postconditions;
    public CMethod symbol;

    public MethodDeclaration(Modifiers modifiers, TypeExpr retType, String name, JavaToken leftParen, AstVector params, JavaToken rightParen, AstVector brackets, JavaToken throwsToken, AstVector throwSpec, Stmt body, JavaToken nameToken, boolean isConstructor, boolean hasSource) {
        super(modifiers);
        this.retType = retType;
        this.name = name;
        this.leftParen = leftParen;
        this.params = params != null && params.size() > 0 ? params.toArray(new FormalParameter[params.size()]) : null;
        this.rightParen = rightParen;
        this.brackets = brackets;
        this.throwsToken = throwsToken;
        this.throwSpec = throwSpec;
        this.body = body;
        this.nameToken = nameToken;
        this.isConstructor = isConstructor;
        this.hasSource = hasSource;
        this.setBody(body);
        if (retType != null) {
            retType.setParent(this);
        }
        if (throwSpec != null) {
            throwSpec.setParent(this);
        }
        int i = 0;
        while (i < this.numFormalParameters()) {
            this.getFormalParameter(i).setParent(this);
            ++i;
        }
        if (brackets != null) {
            brackets.setParent(this);
        }
    }

    public int astType() {
        return 15;
    }

    public int getObjectKind() {
        return 6;
    }

    public AstObject[] getChildren() {
        AstObject[] params = this.getParameters();
        AstCompoundStatement body = this.getBody();
        if (body != null) {
            AstObject[] arr = new AstObject[params.length + 1];
            System.arraycopy(params, 0, arr, 0, params.length);
            arr[arr.length - 1] = body;
            return arr;
        }
        return params;
    }

    public String getElementName() {
        return this.name;
    }

    public String getQualifiedName() {
        return this.symbol.getQualifiedName();
    }

    public CDefinition getSymbol() {
        return this.symbol;
    }

    public AstTypeReference[] getExceptionTypes() {
        if (this.symbol.isPending()) {
            this.symbol.process();
        }
        AstTypeReference[] arr = new AstTypeReference[this.numThrowSpecifiers()];
        int i = 0;
        while (i < arr.length) {
            arr[i] = this.getThrowSpecifier((int)i).type;
            ++i;
        }
        return arr;
    }

    public AstVariable[] getParameters() {
        if (this.symbol.isPending()) {
            this.symbol.process();
        }
        AstVariable[] arrParams = new AstVariable[this.numFormalParameters()];
        int i = 0;
        while (i < this.numFormalParameters()) {
            arrParams[i] = this.getFormalParameter((int)i).declarator;
            ++i;
        }
        return arrParams;
    }

    public AstTypeReference getReturnType() {
        if (this.symbol.isPending()) {
            this.symbol.process();
        }
        return this.symbol.getType().getExternalType();
    }

    public boolean isConstructor() {
        return this.isConstructor;
    }

    public boolean isInitializer() {
        return false;
    }

    public AstCompoundStatement getBody() {
        CompilationUnit cu;
        AstType type;
        if (this.body == null && (type = this.getDeclaringType()) != null && (cu = (CompilationUnit)type.getCompilationUnit()) != null && cu.sourcePending()) {
            ((PackageDeclaration)this.getPackage()).getModel().processSource(cu);
        }
        if (this.body instanceof Block) {
            return (Block)this.body;
        }
        return null;
    }

    public String getSignature() {
        return this.symbol.getSignature();
    }

    public AstMethod[] getOverridden() {
        HashSet methods = new HashSet();
        this.symbol.getOwnerType().getOverridden(this.symbol, methods);
        AstMethod[] arrMethods = new AstMethod[methods.size()];
        int i = 0;
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            arrMethods[i++] = (AstMethod)((Object)((CMethod)iter.next()).getAST());
        }
        return arrMethods;
    }

    public AstMethod[] overriddenBy() {
        HashSet methods = new HashSet();
        this.symbol.getOwnerType().overriddenBy(this.symbol, methods);
        AstMethod[] arrMethods = new AstMethod[methods.size()];
        int i = 0;
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            arrMethods[i++] = (AstMethod)((Object)((CMethod)iter.next()).getAST());
        }
        return arrMethods;
    }

    public AstDeclaration getReferencedElement() {
        if (this.symbol != null) {
            return this.symbol.getType().getAST();
        }
        return null;
    }

    public boolean isErrorFree() {
        return this.symbol.isErrorFree();
    }

    AstDeclaration[] getDeclarations() {
        return new AstDeclaration[]{this};
    }

    public int numBrackets() {
        return this.brackets == null ? 0 : this.brackets.size();
    }

    public Brackets brackets(int i) {
        return (Brackets)this.brackets.get(i);
    }

    public int numFormalParameters() {
        return this.params == null ? 0 : this.params.length;
    }

    public FormalParameter getFormalParameter(int i) {
        return this.params[i];
    }

    public void addFormalParameter(FormalParameter p) {
        p.setParent(this);
        if (this.params != null) {
            FormalParameter[] newParams = new FormalParameter[this.params.length + 1];
            System.arraycopy(this.params, 0, newParams, 0, this.params.length);
            newParams[this.params.length] = p;
            this.params = newParams;
        } else {
            this.params = new FormalParameter[]{p};
        }
    }

    public void addThrowSpecifier(ThrowSpecifier spec) {
        if (this.throwSpec == null) {
            this.throwSpec = new AstVector();
        }
        this.throwSpec.add(spec);
    }

    public int numThrowSpecifiers() {
        return this.throwSpec == null ? 0 : this.throwSpec.size();
    }

    public ThrowSpecifier getThrowSpecifier(int i) {
        return (ThrowSpecifier)this.throwSpec.get(i);
    }

    public boolean hasSource() {
        return this.hasSource;
    }

    public Block getBlockBody() {
        if (this.body instanceof Block) {
            return (Block)this.body;
        }
        return null;
    }

    public void setBody(Stmt body) {
        this.body = body;
        if (body != null) {
            body.setParent(this);
            if (body instanceof Block) {
                Block bl = (Block)body;
                bl.collectLocalVariables();
                int i = 0;
                while (i < this.numFormalParameters()) {
                    bl.addLocalVariable(this.getFormalParameter((int)i).declarator, true);
                    ++i;
                }
            }
        }
    }

    public void accept(Visitor visitor) {
        visitor.visitMethodDeclaration(this);
    }

    public void traverse(Visitor visitor) {
        if (this.modifiers != null) {
            this.modifiers.action(visitor);
        }
        if (this.retType != null) {
            this.retType.action(visitor);
        }
        int i = 0;
        while (i < this.numFormalParameters()) {
            this.getFormalParameter(i).action(visitor);
            ++i;
        }
        if (this.throwSpec != null) {
            this.throwSpec.action(visitor);
        }
        if (this.brackets != null) {
            this.brackets.action(visitor);
        }
        if ((visitor.getAction() & 4) != 0 && this.body != null) {
            this.body.action(visitor);
        }
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        if (this.modifiers == oldObj) {
            this.modifiers = (Modifiers)newObj;
            return true;
        }
        if (this.retType == oldObj) {
            this.retType = (TypeExpr)newObj;
            return true;
        }
        int i = 0;
        while (i < this.params.length) {
            if (this.params[i] == oldObj) {
                this.params[i] = (FormalParameter)newObj;
                return true;
            }
            ++i;
        }
        if (this.body == oldObj) {
            this.body = (Block)newObj;
            return true;
        }
        return AstVector.replace(this.throwSpec, oldObj, newObj) || AstVector.replace(this.brackets, oldObj, newObj);
    }

    public JavaToken leftToken() {
        if (this.modifiers != null && this.modifiers.leftToken() != null) {
            return this.modifiers.leftToken();
        }
        if (this.retType != null) {
            return this.retType.leftToken();
        }
        return this.nameToken;
    }

    public JavaToken rightToken() {
        if (this.body != null) {
            return this.body.rightToken();
        }
        return null;
    }

    void setReferee(Declaration decl) {
        TypeDeclaration type = (TypeDeclaration)decl;
        this.symbol.setType(type.symbol.getArrayType((CTopLevel)type.symbol.getPackage().getParent(), this.symbol.getType().numDimensions()));
        type.symbol.addDependence(this.symbol.getInnermostType());
        this.setSymbol(this.symbol);
    }

    public void setSymbol(CMethod symbol) {
        this.symbol = symbol;
        symbol.getType().addReference(this);
    }

    public AstExpression[] getPreconditions() {
        if (this.preconditions == null) {
            this.preconditions = CommentParser.getPreconditions(this);
        }
        return this.preconditions;
    }

    public AstExpression[] getPostconditions() {
        if (this.postconditions == null) {
            this.postconditions = CommentParser.getPostconditions(this);
        }
        return this.postconditions;
    }
}

