/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstMethodCallExpression;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.internal.jparser.ast.AstVector;
import com.togethersoft.sca.internal.jparser.ast.Expr;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.Visitor;

public class MethodCall
extends Expr
implements AstMethodCallExpression {
    public Expr method;
    AstVector arguments;
    public JavaToken leftParen;
    public JavaToken rightParen;

    public MethodCall(Expr method, JavaToken leftParen, AstVector arguments, JavaToken rightParen) {
        this.method = method;
        this.leftParen = leftParen;
        this.arguments = arguments;
        this.rightParen = rightParen;
        method.setParent(this);
        if (arguments != null) {
            arguments.setParent(this);
        }
    }

    public int astType() {
        return 16;
    }

    public int getObjectKind() {
        return 38;
    }

    public AstExpression[] getOperands() {
        int count = 1 + (this.arguments == null ? 0 : this.arguments.size());
        AstExpression[] arrOperands = new AstExpression[count];
        if (this.arguments != null) {
            this.arguments.toArray(arrOperands);
        }
        arrOperands[count - 1] = this.method;
        return arrOperands;
    }

    public AstExpression getMethodExpression() {
        return this.method;
    }

    public AstExpression[] getArguments() {
        return this.toExprArray(this.arguments);
    }

    public int numArguments() {
        return this.arguments == null ? 0 : this.arguments.size();
    }

    public Expr argument(int i) {
        return (Expr)this.arguments.get(i);
    }

    public AstVector getArgumentsVector() {
        return this.arguments;
    }

    public void accept(Visitor visitor) {
        if (visitor.exprVisitor != null) {
            visitor.exprVisitor.visitMethodCallExpression(this);
        } else {
            visitor.visitMethodCall(this);
        }
    }

    public void traverse(Visitor visitor) {
        this.method.action(visitor);
        if (this.arguments != null) {
            this.arguments.action(visitor);
        }
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        if (this.method == oldObj) {
            this.method = (Expr)newObj;
            return true;
        }
        return AstVector.replace(this.arguments, oldObj, newObj);
    }

    public JavaToken leftToken() {
        return this.method.leftToken();
    }

    public JavaToken rightToken() {
        return this.rightParen;
    }
}

