/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstLiteral;
import com.togethersoft.sca.internal.jparser.ast.Expr;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.Visitor;
import com.togethersoft.sca.internal.jparser.symbol.ErrorMgr;

public abstract class Literal
extends Expr
implements AstLiteral {
    protected JavaToken literalToken;
    protected boolean hasGoodValue = false;

    public Literal(JavaToken literalToken) {
        this.literalToken = literalToken;
    }

    public int astType() {
        return 14;
    }

    public int getObjectKind() {
        return 37;
    }

    public AstExpression[] getOperands() {
        return Expr.NO_OPERANDS;
    }

    public String getText() {
        return this.literalToken.getText();
    }

    public void setText(String value) {
        this.literalToken.setText(value);
    }

    public boolean hasGoodValue() {
        return this.hasGoodValue;
    }

    public void accept(Visitor visitor) {
        if (visitor.exprVisitor != null) {
            visitor.exprVisitor.visitLiteral(this);
        } else {
            visitor.visitLiteral(this);
        }
    }

    public void traverse(Visitor visitor) {
    }

    public JavaToken leftToken() {
        return this.literalToken;
    }

    public JavaToken rightToken() {
        return this.literalToken;
    }

    public abstract boolean eval();

    protected long intEval(JavaToken literalToken, boolean isLong) {
        int maxBits = isLong ? 64 : 32;
        long computedValue = 0L;
        String source = literalToken.getText();
        int length = literalToken.getText().length();
        if (isLong) {
            --length;
        }
        this.hasGoodValue = false;
        if (source.charAt(0) == '0') {
            int digitValue;
            int radix;
            int j;
            int shift;
            if (length == 1) {
                this.hasGoodValue = true;
                return computedValue;
            }
            if (source.charAt(1) == 'x' || source.charAt(1) == 'X') {
                shift = 4;
                j = 2;
                radix = 16;
            } else {
                shift = 3;
                j = 1;
                radix = 8;
            }
            while (source.charAt(j) == '0') {
                if (++j != length) continue;
                this.hasGoodValue = true;
                return computedValue;
            }
            if ((digitValue = Character.digit(source.charAt(j++), radix)) < 0) {
                ErrorMgr.report(34, literalToken, literalToken, literalToken.getText());
                return 0L;
            }
            int numBits = digitValue >= 8 ? 4 : (digitValue >= 4 ? 3 : (digitValue >= 2 ? 2 : 1));
            computedValue = digitValue;
            while (j < length) {
                if ((numBits += shift) > maxBits) {
                    ErrorMgr.report(34, literalToken, literalToken, literalToken.getText());
                    return 0L;
                }
                digitValue = Character.digit(source.charAt(j), radix);
                if (digitValue < 0) {
                    ErrorMgr.report(34, literalToken, literalToken, literalToken.getText());
                    return 0L;
                }
                computedValue = computedValue << shift | (long)digitValue;
                ++j;
            }
        } else {
            int i = 0;
            while (i < length) {
                int digitValue = Character.digit(source.charAt(i), 10);
                if (digitValue < 0) {
                    ErrorMgr.report(34, literalToken, literalToken, literalToken.getText());
                    return 0L;
                }
                long previousValue = computedValue;
                computedValue = 10L * computedValue + (long)digitValue;
                if (isLong && previousValue > computedValue || !isLong && computedValue > Integer.MAX_VALUE) {
                    ErrorMgr.report(34, literalToken, literalToken, literalToken.getText());
                    return 0L;
                }
                ++i;
            }
        }
        this.hasGoodValue = true;
        return computedValue;
    }

    public abstract int getLiteralKind();
}

