/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import antlr.CommonToken;
import com.togethersoft.sca.internal.jparser.ast.Comment;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class JavaToken
extends CommonToken
implements Serializable {
    private int offset;
    private int endColumn;
    private Comment[] comments;

    public JavaToken() {
    }

    public JavaToken(String text) {
        super(text);
    }

    public JavaToken(int type, String text) {
        super(type, text);
    }

    public JavaToken(int type, String text, int line, int column, int offset, int endColumn) {
        super(type, text);
        this.setLine(line);
        this.setColumn(column);
        this.offset = offset;
        this.endColumn = endColumn;
    }

    public void setPosition(JavaToken token) {
        this.setType(44);
        this.setColumn(token.getColumn());
        this.setLine(token.getLine());
    }

    public void setColumn(JavaToken token) {
        this.setType(44);
        this.setColumn(token.getColumn());
    }

    public void setPosition(int column, int line) {
        this.setType(44);
        this.setColumn(column);
        this.setLine(line);
    }

    public int getOffset() {
        return this.offset;
    }

    public int getEndLine() {
        return this.getLine();
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public int getStartLine() {
        int startLine = this.getLine();
        if (this.comments != null) {
            int i = this.comments.length;
            while (--i >= 0) {
                int commentStart = this.comments[i].getPosition().getStartLine();
                if (commentStart >= startLine) continue;
                startLine = commentStart;
            }
        }
        return startLine;
    }

    public int getStartColumn() {
        int startColumn = this.getColumn();
        int startLine = this.getLine();
        if (this.comments != null) {
            int i = this.comments.length;
            while (--i >= 0) {
                int commentStartColumn;
                int commentStartLine = this.comments[i].getStartLine();
                if (commentStartLine < startLine) {
                    startLine = commentStartLine;
                    startColumn = this.comments[i].getStartColumn();
                    continue;
                }
                if (commentStartLine != startLine || (commentStartColumn = this.comments[i].getStartColumn()) >= startColumn) continue;
                startColumn = commentStartColumn;
            }
        }
        return startColumn;
    }

    public Comment[] getComments() {
        return this.comments;
    }

    public void addComment(Comment cmt) {
        if (this.comments != null) {
            Comment[] newComments = new Comment[this.comments.length + 1];
            System.arraycopy(this.comments, 0, newComments, 1, this.comments.length);
            this.comments = newComments;
        } else {
            this.comments = new Comment[1];
        }
        this.comments[0] = cmt;
    }

    public void setComments(Comment[] comments) {
        this.comments = comments;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.getText());
        s.writeInt(this.getLine());
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.setText((String)s.readObject());
        this.setLine(s.readInt());
    }
}

