/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.internal.jparser.ast.Ast;
import com.togethersoft.sca.internal.jparser.ast.Declaration;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.Name;
import com.togethersoft.sca.internal.jparser.ast.TypeDeclaration;
import com.togethersoft.sca.internal.jparser.ast.Visitor;
import com.togethersoft.sca.internal.jparser.symbol.CClassType;

public class Inheritance
extends Ast {
    private Name type;
    private boolean isImplementation;
    private CClassType symbol;

    public Inheritance(Name type, boolean isImplementation) {
        this.type = type;
        this.isImplementation = isImplementation;
        type.setParent(this);
    }

    public int astType() {
        return 61;
    }

    public int getObjectKind() {
        return 0;
    }

    public AstObject[] getChildren() {
        return Ast.EMPTY_NODE_SET;
    }

    public boolean isImplementation() {
        return this.isImplementation;
    }

    public Name getType() {
        return this.type;
    }

    public void accept(Visitor visitor) {
        visitor.visitInheritance(this);
    }

    public void traverse(Visitor visitor) {
        this.type.action(visitor);
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        if (this.type == oldObj) {
            this.type = (Name)newObj;
            return true;
        }
        return false;
    }

    public JavaToken leftToken() {
        return this.type.leftToken();
    }

    public JavaToken rightToken() {
        return this.type.rightToken();
    }

    void setReferee(Declaration decl) {
        CClassType supertype = ((TypeDeclaration)decl).symbol;
        CClassType subtype = ((TypeDeclaration)this.getParent()).symbol;
        if (this.isImplementation) {
            subtype.removeInterface(this.symbol);
            subtype.addInterface(supertype);
        } else {
            subtype.setSuperClass(supertype);
        }
        supertype.addDependence(subtype);
        this.setSymbol(supertype, subtype);
    }

    public void setSymbol(CClassType supertype, CClassType subtype) {
        this.symbol = supertype;
        supertype.addReference(this);
        supertype.addSubclass(subtype);
    }
}

