/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstUnaryExpression;
import com.togethersoft.sca.internal.jparser.ast.Expr;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.Visitor;

public class IncDecExpr
extends Expr
implements AstUnaryExpression {
    Expr expression;
    JavaToken opToken;
    int kind;

    public IncDecExpr(Expr expression, int kind, JavaToken opToken) {
        this.expression = expression;
        this.kind = kind;
        this.opToken = opToken;
        expression.setParent(this);
    }

    public int astType() {
        return 32;
    }

    public int getObjectKind() {
        return 43;
    }

    public AstExpression[] getOperands() {
        return new AstExpression[]{this.expression};
    }

    public int getExpressionKind() {
        return this.kind;
    }

    public AstExpression getOperand() {
        return this.expression;
    }

    public Expr expr() {
        return this.expression;
    }

    public void accept(Visitor visitor) {
        if (visitor.exprVisitor != null) {
            visitor.exprVisitor.visitUnaryExpression(this);
        } else {
            visitor.visitIncDecExpr(this);
        }
    }

    public void traverse(Visitor visitor) {
        this.expression.action(visitor);
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        if (this.expression == oldObj) {
            this.expression = (Expr)newObj;
            return true;
        }
        return false;
    }

    public JavaToken leftToken() {
        if (this.kind == 4 || this.kind == 5) {
            return this.opToken;
        }
        return this.expression.leftToken();
    }

    public JavaToken rightToken() {
        if (this.kind == 4 || this.kind == 5) {
            return this.expression.rightToken();
        }
        return this.opToken;
    }
}

