/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstImport;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.internal.jparser.ast.Ast;
import com.togethersoft.sca.internal.jparser.ast.CompilationUnit;
import com.togethersoft.sca.internal.jparser.ast.Declaration;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.Name;
import com.togethersoft.sca.internal.jparser.ast.TypeDeclaration;
import com.togethersoft.sca.internal.jparser.ast.Visitor;
import com.togethersoft.sca.internal.jparser.symbol.CClassType;
import com.togethersoft.sca.internal.jparser.symbol.CCompilationUnit;
import com.togethersoft.sca.internal.jparser.symbol.CScope;

public class ImportDeclaration
extends Ast
implements AstImport {
    public Name type;
    public boolean importPackage;
    private CScope symbol;
    public JavaToken importToken;

    public ImportDeclaration(Name type, boolean importPackage) {
        this.type = type;
        this.importPackage = importPackage;
        type.setParent(this);
    }

    public int astType() {
        return 13;
    }

    public int getObjectKind() {
        return 3;
    }

    public AstObject[] getChildren() {
        return Ast.EMPTY_NODE_SET;
    }

    public String getElementName() {
        return this.type.getFullName();
    }

    public boolean isOnDemand() {
        return this.importPackage;
    }

    public AstDeclaration getReferencedElement() {
        return this.symbol != null ? this.symbol.getAST() : null;
    }

    public void accept(Visitor visitor) {
        visitor.visitImportDeclaration(this);
    }

    public void traverse(Visitor visitor) {
        this.type.action(visitor);
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        if (this.type == oldObj) {
            this.type = (Name)newObj;
            return true;
        }
        return false;
    }

    public JavaToken leftToken() {
        return this.importToken;
    }

    public JavaToken rightToken() {
        return this.type.rightToken();
    }

    void setReferee(Declaration decl) {
        TypeDeclaration type = (TypeDeclaration)decl;
        CCompilationUnit cu = ((CompilationUnit)this.getParent()).symbol;
        cu.removeImportedType((CClassType)this.symbol);
        cu.addImportedType(type.symbol);
        this.setSymbol(type.symbol);
    }

    public void setSymbol(CScope symbol) {
        this.symbol = symbol;
        symbol.addReference(this);
    }
}

