/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstIfStatement;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstStatement;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.ParExpr;
import com.togethersoft.sca.internal.jparser.ast.Stmt;
import com.togethersoft.sca.internal.jparser.ast.Visitor;

public class IfStmt
extends Stmt
implements AstIfStatement {
    private JavaToken ifToken;
    private ParExpr condition;
    private Stmt thenStmt;
    public JavaToken elseToken;
    private Stmt elseStmt;

    public IfStmt(JavaToken ifToken, ParExpr condition, Stmt thenStmt, JavaToken elseToken, Stmt elseStmt) {
        this.ifToken = ifToken;
        this.condition = condition;
        this.thenStmt = thenStmt;
        this.elseToken = elseToken;
        this.elseStmt = elseStmt;
        condition.setParent(this);
        thenStmt.setParent(this);
        if (elseStmt != null) {
            elseStmt.setParent(this);
        }
    }

    public int astType() {
        return 41;
    }

    public int getObjectKind() {
        return 16;
    }

    public AstObject[] getChildren() {
        if (this.elseStmt != null) {
            return new AstObject[]{this.condition.expr(), this.thenStmt, this.elseStmt};
        }
        return new AstObject[]{this.condition.expr(), this.thenStmt};
    }

    public AstExpression getCondition() {
        return this.condition.expr();
    }

    public AstStatement getThenStatement() {
        return this.thenStmt;
    }

    public AstStatement getElseStatement() {
        return this.elseStmt;
    }

    public ParExpr condition() {
        return this.condition;
    }

    public Stmt thenStmt() {
        return this.thenStmt;
    }

    public Stmt elseStmt() {
        return this.elseStmt;
    }

    public void accept(Visitor visitor) {
        if (visitor.stmtVisitor != null) {
            visitor.stmtVisitor.visitIfStatement(this);
        } else {
            visitor.visitIfStmt(this);
        }
    }

    public void traverse(Visitor visitor) {
        this.condition.action(visitor);
        this.thenStmt.action(visitor);
        if (this.elseStmt != null) {
            this.elseStmt.action(visitor);
        }
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        if (this.condition == oldObj) {
            this.condition = (ParExpr)newObj;
        } else if (this.thenStmt == oldObj) {
            this.thenStmt = (Stmt)newObj;
        } else if (this.elseStmt == oldObj) {
            this.elseStmt = (Stmt)newObj;
        } else {
            return false;
        }
        return true;
    }

    public JavaToken leftToken() {
        return this.ifToken;
    }

    public JavaToken rightToken() {
        return this.elseStmt != null ? this.elseStmt.rightToken() : this.thenStmt.rightToken();
    }
}

