/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstForStatement;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstStatement;
import com.togethersoft.sca.internal.jparser.ast.AstVector;
import com.togethersoft.sca.internal.jparser.ast.Expr;
import com.togethersoft.sca.internal.jparser.ast.ExprStmt;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.Stmt;
import com.togethersoft.sca.internal.jparser.ast.Visitor;

public class ForStmt
extends Stmt
implements AstForStatement {
    private JavaToken forToken;
    public JavaToken leftParen;
    private AstVector initStmtList;
    private Expr condition;
    private AstVector updateStmtList;
    public JavaToken rightParen;
    private Stmt body;

    public ForStmt(JavaToken forToken, JavaToken leftParen, AstVector initStmtList, Expr condition, AstVector updateStmtList, JavaToken rightParen, Stmt body) {
        this.forToken = forToken;
        this.leftParen = leftParen;
        this.initStmtList = initStmtList;
        this.condition = condition;
        this.updateStmtList = updateStmtList;
        this.rightParen = rightParen;
        this.body = body;
        if (initStmtList != null) {
            initStmtList.setParent(this);
        }
        if (condition != null) {
            condition.setParent(this);
        }
        if (updateStmtList != null) {
            updateStmtList.setParent(this);
        }
        body.setParent(this);
    }

    public int astType() {
        return 44;
    }

    public int getObjectKind() {
        return 17;
    }

    public AstObject[] getChildren() {
        int nInits = this.numInitStatements();
        int nUpdates = this.numUpdateStatements();
        int size = nInits + nUpdates + 1;
        if (this.condition != null) {
            ++size;
        }
        AstObject[] arr = new AstObject[size];
        int idx = 0;
        int i = 0;
        while (i < nInits) {
            arr[idx++] = this.initStatement(i);
            ++i;
        }
        if (this.condition != null) {
            arr[idx++] = this.condition;
        }
        int i2 = 0;
        while (i2 < nUpdates) {
            arr[idx++] = this.updateStatement(i2);
            ++i2;
        }
        arr[idx] = this.body;
        return arr;
    }

    public AstStatement[] getInitializers() {
        return this.toStmtArray(this.initStmtList);
    }

    public AstExpression getCondition() {
        return this.condition;
    }

    public AstStatement[] getUpdateStatements() {
        return this.toStmtArray(this.updateStmtList);
    }

    public AstStatement getBody() {
        return this.body;
    }

    public int numInitStatements() {
        return this.initStmtList != null ? this.initStmtList.size() : 0;
    }

    public Stmt initStatement(int i) {
        return (Stmt)this.initStmtList.get(i);
    }

    public Expr condition() {
        return this.condition;
    }

    public int numUpdateStatements() {
        return this.updateStmtList != null ? this.updateStmtList.size() : 0;
    }

    public ExprStmt updateStatement(int i) {
        return (ExprStmt)this.updateStmtList.get(i);
    }

    public Stmt body() {
        return this.body;
    }

    public void accept(Visitor visitor) {
        if (visitor.stmtVisitor != null) {
            visitor.stmtVisitor.visitForStatement(this);
        } else {
            visitor.visitForStmt(this);
        }
    }

    public void traverse(Visitor visitor) {
        if (this.initStmtList != null) {
            this.initStmtList.action(visitor);
        }
        if (this.condition != null) {
            this.condition.action(visitor);
        }
        if (this.updateStmtList != null) {
            this.updateStmtList.action(visitor);
        }
        this.body.action(visitor);
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        if (this.condition == oldObj) {
            this.condition = (Expr)newObj;
        } else if (this.body == oldObj) {
            this.body = (Stmt)newObj;
        } else {
            return AstVector.replace(this.initStmtList, oldObj, newObj) || AstVector.replace(this.updateStmtList, oldObj, newObj);
        }
        return true;
    }

    public JavaToken leftToken() {
        return this.forToken;
    }

    public JavaToken rightToken() {
        return this.body.rightToken();
    }
}

