/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstFloatLiteral;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.Literal;
import com.togethersoft.sca.internal.jparser.symbol.ErrorMgr;

public class FloatLiteral
extends Literal
implements AstFloatLiteral {
    private float value;

    public FloatLiteral(JavaToken literalToken) {
        super(literalToken);
    }

    public FloatLiteral(float value) {
        super(null);
        this.value = value;
        this.hasGoodValue = true;
    }

    public int getLiteralKind() {
        return 2;
    }

    public float getValue() {
        return this.value;
    }

    public boolean eval() {
        Float evalValue;
        if (this.hasGoodValue) {
            return true;
        }
        try {
            evalValue = Float.valueOf(this.getText());
        }
        catch (NumberFormatException e) {
            ErrorMgr.report(34, this.literalToken, this.literalToken, this.literalToken.getText());
            this.hasGoodValue = false;
            return false;
        }
        this.value = evalValue.floatValue();
        this.hasGoodValue = true;
        return true;
    }
}

