/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstCompoundStatement;
import com.togethersoft.sca.ast.AstFinallyClause;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.internal.jparser.ast.Block;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.Stmt;
import com.togethersoft.sca.internal.jparser.ast.Visitor;

public class FinallyClause
extends Stmt
implements AstFinallyClause {
    private JavaToken finallyToken;
    private Block body;

    public FinallyClause(JavaToken finallyToken, Block body) {
        this.finallyToken = finallyToken;
        this.body = body;
        body.setParent(this);
    }

    public int astType() {
        return 47;
    }

    public int getObjectKind() {
        return 25;
    }

    public AstObject[] getChildren() {
        return new AstObject[]{this.body};
    }

    public AstCompoundStatement getBody() {
        return this.body;
    }

    public Block body() {
        return this.body;
    }

    public void accept(Visitor visitor) {
        visitor.visitFinallyClause(this);
    }

    public void traverse(Visitor visitor) {
        this.body.action(visitor);
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        if (this.body == oldObj) {
            this.body = (Block)newObj;
            return true;
        }
        return false;
    }

    public JavaToken leftToken() {
        return this.finallyToken;
    }

    public JavaToken rightToken() {
        return this.body.rightToken();
    }
}

