/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstExpressionStatement;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.internal.jparser.ast.Expr;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.Stmt;
import com.togethersoft.sca.internal.jparser.ast.Visitor;

public class ExprStmt
extends Stmt
implements AstExpressionStatement {
    private Expr expr;
    public JavaToken semicolon;

    public ExprStmt(Expr expr, JavaToken semicolon) {
        this.expr = expr;
        this.semicolon = semicolon;
        expr.setParent(this);
    }

    public int astType() {
        return 9;
    }

    public int getObjectKind() {
        return 23;
    }

    public AstObject[] getChildren() {
        return new AstObject[]{this.expr};
    }

    public AstExpression getExpression() {
        return this.expr;
    }

    public Expr expr() {
        return this.expr;
    }

    public void accept(Visitor visitor) {
        if (visitor.stmtVisitor != null) {
            visitor.stmtVisitor.visitExpressionStatement(this);
        } else {
            visitor.visitExprStmt(this);
        }
    }

    public void traverse(Visitor visitor) {
        this.expr.action(visitor);
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        if (this.expr == oldObj) {
            this.expr = (Expr)newObj;
            return true;
        }
        return false;
    }

    public JavaToken leftToken() {
        return this.expr.leftToken();
    }

    public JavaToken rightToken() {
        if (this.semicolon != null) {
            return this.semicolon;
        }
        return this.expr.rightToken();
    }
}

