/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstTypeReference;
import com.togethersoft.sca.internal.jparser.ast.Ast;
import com.togethersoft.sca.internal.jparser.symbol.CBadType;
import com.togethersoft.sca.internal.jparser.symbol.CDefinition;
import com.togethersoft.sca.internal.jparser.symbol.CMethod;
import com.togethersoft.sca.internal.jparser.symbol.CPackage;
import com.togethersoft.sca.internal.jparser.symbol.CType;
import com.togethersoft.sca.internal.jparser.symbol.CVariable;
import java.util.Collection;

public abstract class Expr
extends Ast
implements AstExpression {
    public CDefinition exprType;
    public CType runtype;
    public boolean isConstant;
    protected static final AstExpression[] NO_OPERANDS = new AstExpression[0];

    public AstObject[] getChildren() {
        return this.getOperands();
    }

    public AstTypeReference getType() {
        return this.type();
    }

    public AstTypeReference getRuntimeType() {
        return this.runtype != null ? this.runtype : this.type();
    }

    public boolean isConstant() {
        return this.isConstant;
    }

    public CDefinition getDef() {
        return this.exprType;
    }

    public AstDeclaration getReferencedElement() {
        if (this.exprType == null) {
            return null;
        }
        if (this.exprType instanceof CType) {
            return ((CType)this.exprType).getAST();
        }
        if (this.exprType instanceof CVariable) {
            return ((CVariable)this.exprType).getAST();
        }
        if (this.exprType instanceof CMethod) {
            return ((CMethod)this.exprType).getAST();
        }
        if (this.exprType instanceof CPackage) {
            return ((CPackage)this.exprType).getAST();
        }
        return null;
    }

    public CType type() {
        if (this.exprType == null) {
            return CBadType.getInstance();
        }
        if (this.exprType instanceof CType) {
            return (CType)this.exprType;
        }
        if (this.exprType instanceof CVariable) {
            CVariable v = (CVariable)this.exprType;
            return v.getType();
        }
        if (this.exprType instanceof CMethod) {
            CMethod m = (CMethod)this.exprType;
            return m.getType();
        }
        return CBadType.getInstance();
    }

    protected AstExpression[] toExprArray(AstExpression e, Collection c) {
        int count = (e != null ? 1 : 0) + (c != null ? c.size() : 0);
        AstExpression[] arr = new AstExpression[count];
        if (c != null) {
            c.toArray(arr);
        }
        if (e != null) {
            arr[count - 1] = e;
        }
        return arr;
    }

    protected AstExpression[] toExprArray(Collection c) {
        if (c == null) {
            return NO_OPERANDS;
        }
        return c.toArray(new AstExpression[c.size()]);
    }

    public abstract AstExpression[] getOperands();
}

