/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstDoubleLiteral;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.Literal;
import com.togethersoft.sca.internal.jparser.symbol.ErrorMgr;

public class DoubleLiteral
extends Literal
implements AstDoubleLiteral {
    private double value;

    public DoubleLiteral(JavaToken literalToken) {
        super(literalToken);
    }

    public DoubleLiteral(double value) {
        super(null);
        this.value = value;
        this.hasGoodValue = true;
    }

    public int getLiteralKind() {
        return 3;
    }

    public double getValue() {
        return this.value;
    }

    public boolean eval() {
        Double evalValue;
        if (this.hasGoodValue) {
            return true;
        }
        try {
            evalValue = Double.valueOf(this.getText());
        }
        catch (NumberFormatException e) {
            ErrorMgr.report(34, this.literalToken, this.literalToken, this.literalToken.getText());
            this.hasGoodValue = false;
            return false;
        }
        this.value = evalValue;
        this.hasGoodValue = true;
        return true;
    }
}

