/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstDoStatement;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstStatement;
import com.togethersoft.sca.internal.jparser.ast.Expr;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.ParExpr;
import com.togethersoft.sca.internal.jparser.ast.Stmt;
import com.togethersoft.sca.internal.jparser.ast.Visitor;

public class DoStmt
extends Stmt
implements AstDoStatement {
    public JavaToken doToken;
    private Stmt body;
    private ParExpr condition;
    public JavaToken whileToken;
    public JavaToken semiToken;

    public DoStmt(JavaToken doToken, Stmt body, ParExpr condition, JavaToken whileToken, JavaToken semiToken) {
        this.doToken = doToken;
        this.body = body;
        this.condition = condition;
        this.whileToken = whileToken;
        this.semiToken = semiToken;
        condition.setParent(this);
        body.setParent(this);
    }

    public int astType() {
        return 42;
    }

    public int getObjectKind() {
        return 27;
    }

    public AstObject[] getChildren() {
        return new AstObject[]{this.body, this.condition.expr()};
    }

    public AstStatement getBody() {
        return this.body;
    }

    public AstExpression getCondition() {
        return this.condition.expr();
    }

    public Expr condition() {
        return this.condition;
    }

    public Stmt body() {
        return this.body;
    }

    public void accept(Visitor visitor) {
        if (visitor.stmtVisitor != null) {
            visitor.stmtVisitor.visitDoStatement(this);
        } else {
            visitor.visitDoStmt(this);
        }
    }

    public void traverse(Visitor visitor) {
        this.body.action(visitor);
        this.condition.action(visitor);
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        if (this.body == oldObj) {
            this.body = (Stmt)newObj;
        } else if (this.condition == oldObj) {
            this.condition = (ParExpr)newObj;
        } else {
            return false;
        }
        return true;
    }

    public JavaToken leftToken() {
        return this.doToken;
    }

    public JavaToken rightToken() {
        return this.semiToken;
    }
}

