/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstCompilationUnit;
import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstImport;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.ast.AstVariable;
import com.togethersoft.sca.internal.jparser.ast.AstVector;
import com.togethersoft.sca.internal.jparser.ast.CompilationUnit;
import com.togethersoft.sca.internal.jparser.ast.Declaration;
import com.togethersoft.sca.internal.jparser.ast.FormalParameter;
import com.togethersoft.sca.internal.jparser.ast.MethodDeclaration;
import com.togethersoft.sca.internal.jparser.ast.Name;
import com.togethersoft.sca.internal.jparser.ast.ThrowSpecifier;
import com.togethersoft.sca.internal.jparser.ast.TypeDeclaration;
import com.togethersoft.sca.internal.jparser.ast.TypeExpr;
import com.togethersoft.sca.internal.jparser.ast.VariableDeclaration;
import com.togethersoft.sca.internal.jparser.ast.VariableDeclarator;

public class Diff {
    private static final int TYPE_MOD_MASK = 1055;
    private static final int FIELD_MOD_MASK = 31;
    private static final int METHOD_MOD_MASK = 1311;

    public static boolean diffFiles(AstCompilationUnit file1, AstCompilationUnit file2) {
        String pkg2;
        String pkg1 = Diff.getPackageName(file1);
        if (!pkg1.equals(pkg2 = Diff.getPackageName(file2))) {
            return true;
        }
        if (Diff.diffImports(file1.getImports(), file2.getImports())) {
            return true;
        }
        return Diff.diffTypes(file1.getTypes(), file2.getTypes());
    }

    public static boolean diffTypes(AstType type1, AstType type2) {
        TypeDeclaration t1 = (TypeDeclaration)type1;
        TypeDeclaration t2 = (TypeDeclaration)type2;
        if (!t1.getElementName().equals(t2.getElementName())) {
            return true;
        }
        if (Diff.compModifiers(t1, t2, 1055)) {
            return true;
        }
        if (Diff.diffTypes(type1.getTypes(), type2.getTypes())) {
            return true;
        }
        if (Diff.diffMethods(type1.getMethods(), type2.getMethods())) {
            return true;
        }
        if (Diff.diffMethods(type1.getConstructors(), type2.getConstructors())) {
            return true;
        }
        if (Diff.diffFields(type1.getFields(), type2.getFields())) {
            return true;
        }
        Diff.setLinks(t1, t2);
        return false;
    }

    private static boolean diffTypes(AstType[] types1, AstType[] types2) {
        if (types1.length != types2.length) {
            return true;
        }
        int i = 0;
        while (i < types1.length) {
            AstType t = (AstType)Diff.findDecl(types2, types1[i].getElementName(), true);
            if (t == null) {
                return true;
            }
            if (Diff.diffTypes(types1[i], t)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean diffMethods(AstMethod[] methods1, AstMethod[] methods2) {
        int i = 0;
        while (i < methods1.length) {
            if (!Diff.isPrivate(methods1[i])) {
                AstMethod m = Diff.findMethod(methods2, (MethodDeclaration)methods1[i]);
                if (m == null) {
                    return true;
                }
                if (Diff.diffMethods((MethodDeclaration)methods1[i], (MethodDeclaration)m)) {
                    return true;
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < methods2.length) {
            if (methods2[i2] != null && !Diff.isPrivate(methods2[i2])) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    private static boolean diffFields(AstVariable[] fields1, AstVariable[] fields2) {
        int i = 0;
        while (i < fields1.length) {
            if (!Diff.isPrivate(fields1[i])) {
                AstVariable f = (AstVariable)Diff.findDecl(fields2, fields1[i].getElementName(), false);
                if (f == null) {
                    return true;
                }
                VariableDeclarator v1 = (VariableDeclarator)fields1[i];
                VariableDeclarator v2 = (VariableDeclarator)f;
                if (Diff.diffVariables(v1, ((VariableDeclaration)v1.decl).typeSpec, v2, ((VariableDeclaration)v2.decl).typeSpec, 31)) {
                    return true;
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < fields2.length) {
            if (fields2[i2] != null && !Diff.isPrivate(fields2[i2])) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    private static boolean diffMethods(MethodDeclaration m1, MethodDeclaration m2) {
        int nThrow2;
        if (!m1.hasSource() || !m2.hasSource()) {
            return true;
        }
        if (Diff.compModifiers(m1, m2, 1311)) {
            return true;
        }
        if (Diff.numBrackets(m1.brackets, m1.retType) != Diff.numBrackets(m2.brackets, m2.retType)) {
            return true;
        }
        if (!(m1.isConstructor() && m2.isConstructor() || !Diff.compTypes(m1.retType, m2.retType))) {
            return true;
        }
        int nThrow1 = m1.throwSpec != null ? m1.throwSpec.size() : 0;
        int n = nThrow2 = m2.throwSpec != null ? m2.throwSpec.size() : 0;
        if (nThrow1 != nThrow2) {
            return true;
        }
        int i = 0;
        while (i < nThrow1) {
            Name n1 = ((ThrowSpecifier)m1.throwSpec.get(i)).getThrowType();
            Name n2 = ((ThrowSpecifier)m1.throwSpec.get(i)).getThrowType();
            if (n1 == null || n2 == null) {
                return true;
            }
            if (!n1.getFullName().equals(n2.getFullName())) {
                return true;
            }
            ++i;
        }
        Diff.setLinks(m1, m2);
        return false;
    }

    private static boolean diffVariables(VariableDeclarator v1, TypeExpr type1, VariableDeclarator v2, TypeExpr type2, int mask) {
        if (Diff.compModifiers(v1, v2, mask)) {
            return true;
        }
        if (Diff.numBrackets(v1.brackets, type1) != Diff.numBrackets(v2.brackets, type2)) {
            return true;
        }
        if (Diff.compTypes(type1, type2)) {
            return true;
        }
        Diff.setLinks(v1, v2);
        return false;
    }

    private static int numBrackets(AstVector br, TypeExpr type) {
        int n;
        int n2 = n = br != null ? br.size() : 0;
        if (type != null && type.brackets != null) {
            n += type.brackets.size();
        }
        return n;
    }

    private static boolean compTypes(TypeExpr type1, TypeExpr type2) {
        if (type1 == null || type2 == null) {
            return true;
        }
        if (type1.type == null || type2.type == null) {
            return true;
        }
        return !type1.type.getFullName().equals(type2.type.getFullName());
    }

    private static AstDeclaration findDecl(AstDeclaration[] decls, String name, boolean includePrivate) {
        int i = 0;
        while (i < decls.length) {
            if (decls[i] != null && (includePrivate || !Diff.isPrivate(decls[i])) && decls[i].getElementName().equals(name)) {
                AstDeclaration ret = decls[i];
                decls[i] = null;
                return ret;
            }
            ++i;
        }
        return null;
    }

    private static AstMethod findMethod(AstMethod[] methods, MethodDeclaration m1) {
        String name = m1.getElementName();
        int numParms = m1.numFormalParameters();
        int i = 0;
        while (i < methods.length) {
            block4: {
                MethodDeclaration m2 = (MethodDeclaration)methods[i];
                if (m2 != null && !Diff.isPrivate(m2) && m2.getElementName().equals(name) && numParms == m2.numFormalParameters()) {
                    int j = 0;
                    while (j < numParms) {
                        FormalParameter p1 = m1.getFormalParameter(j);
                        FormalParameter p2 = m2.getFormalParameter(j);
                        if (!Diff.diffVariables(p1.declarator, p1.typeSpec, p2.declarator, p2.typeSpec, 0)) {
                            ++j;
                            continue;
                        }
                        break block4;
                    }
                    methods[i] = null;
                    return m2;
                }
            }
            ++i;
        }
        return null;
    }

    private static boolean compModifiers(Declaration decl1, Declaration decl2, int mask) {
        int mod1 = 0;
        int mod2 = 0;
        if (decl1.modifiers != null) {
            mod1 = decl1.modifiers.mods;
        }
        if (decl2.modifiers != null) {
            mod2 = decl2.modifiers.mods;
        }
        return (mask & (mod1 ^ mod2)) != 0;
    }

    private static String getPackageName(AstCompilationUnit file) {
        CompilationUnit f = (CompilationUnit)file;
        return f.getPackageName() != null ? f.getPackageName().getFullName() : "";
    }

    private static boolean diffImports(AstImport[] imports1, AstImport[] imports2) {
        if (imports1.length != imports2.length) {
            return true;
        }
        int i = 0;
        while (i < imports1.length) {
            String name = imports1[i].getElementName();
            int j = 0;
            while (j < imports2.length) {
                if (imports2[j] != null && imports2[j].getElementName().equals(name) && imports1[i].isOnDemand() == imports2[j].isOnDemand()) {
                    imports2[j] = null;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private static void setLinks(Declaration d1, Declaration d2) {
        d1.link = d2;
        d2.link = d1;
    }

    private static boolean isPrivate(AstDeclaration decl) {
        return decl.isPrivate();
    }
}

