/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstModifier;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstReference;
import com.togethersoft.sca.internal.jparser.ast.Ast;
import com.togethersoft.sca.internal.jparser.ast.Block;
import com.togethersoft.sca.internal.jparser.ast.Expr;
import com.togethersoft.sca.internal.jparser.ast.Modifiers;
import com.togethersoft.sca.internal.jparser.ast.VariableDeclarator;
import com.togethersoft.sca.internal.jparser.symbol.CDefinition;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class Declaration
extends Ast
implements AstDeclaration {
    LinkedList refs;
    transient Declaration link;
    int lineAdjustment;
    public Modifiers modifiers;
    static final AstModifier[] NO_MODIFIERS = new AstModifier[0];

    public Declaration(Modifiers modifiers) {
        this.modifiers = modifiers;
        if (modifiers != null) {
            modifiers.setParent(this);
        }
    }

    abstract AstDeclaration[] getDeclarations();

    public int getModifiers() {
        if (this.getSymbol() != null) {
            return this.getSymbol().getAccess().getModifiers();
        }
        return this.getDeclaredModifiers();
    }

    public void setDeclaredModifiers(int mods) {
        if (this.modifiers == null) {
            this.modifiers = new Modifiers();
            this.modifiers.setParent(this);
        }
        this.modifiers.setModifiers(mods);
    }

    public AstModifier[] getModifiersList() {
        if (this.modifiers == null) {
            return NO_MODIFIERS;
        }
        return this.modifiers.modsVector.toArray(new AstModifier[this.modifiers.modsVector.size()]);
    }

    public int getDeclaredModifiers() {
        if (this.modifiers != null) {
            return this.modifiers.mods;
        }
        return 0;
    }

    public boolean isPublic() {
        return (this.getModifiers() & 1) != 0;
    }

    public boolean isProtected() {
        return (this.getModifiers() & 4) != 0;
    }

    public boolean isPackage() {
        return (this.getModifiers() & 7) == 0;
    }

    public boolean isPrivate() {
        return (this.getModifiers() & 2) != 0;
    }

    public boolean isStatic() {
        return (this.getModifiers() & 8) != 0;
    }

    public boolean isFinal() {
        return (this.getModifiers() & 0x10) != 0;
    }

    public boolean isSynchronized() {
        return (this.getModifiers() & 0x20) != 0;
    }

    public boolean isVolatile() {
        return (this.getModifiers() & 0x40) != 0;
    }

    public boolean isTransient() {
        return (this.getModifiers() & 0x80) != 0;
    }

    public boolean isNative() {
        return (this.getModifiers() & 0x100) != 0;
    }

    public boolean isAbstract() {
        return (this.getModifiers() & 0x400) != 0;
    }

    public boolean isStrictfp() {
        return (this.getModifiers() & 0x800) != 0;
    }

    public AstReference[] getReferences() {
        if (this.refs == null) {
            return new AstReference[0];
        }
        AstReference[] arrRefs = new AstReference[this.refs.size()];
        this.refs.toArray(arrRefs);
        return arrRefs;
    }

    public void addReference(AstObject ref) {
        if (this.refs == null) {
            this.refs = new LinkedList();
        }
        this.refs.add(ref);
    }

    public void removeReference(AstObject ref) {
        if (this.refs == null) {
            return;
        }
        Iterator i = this.refs.iterator();
        while (i.hasNext()) {
            if (i.next() != ref) continue;
            i.remove();
            break;
        }
    }

    public Collection getReferenceList() {
        return this.refs;
    }

    public AstExpression[] getPreconditions() {
        return Expr.NO_OPERANDS;
    }

    public AstExpression[] getPostconditions() {
        return Expr.NO_OPERANDS;
    }

    public AstExpression[] getInvariants() {
        return Expr.NO_OPERANDS;
    }

    public abstract CDefinition getSymbol();

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        this.removeDeepReferences();
        s.defaultWriteObject();
    }

    protected void removeDeepReferences() {
        if (this.refs == null) {
            return;
        }
        Iterator i = this.refs.iterator();
        while (i.hasNext()) {
            if (!this.isInBody((Ast)i.next())) continue;
            i.remove();
        }
        if (this.refs.size() == 0) {
            this.refs = null;
        }
    }

    private boolean isInBody(Ast ast) {
        AstObject parent = ast.getParent();
        while (parent != null && !(parent instanceof Block) && !(parent instanceof VariableDeclarator)) {
            parent = parent.getParent();
        }
        return parent != null;
    }

    public void swapWith(AstDeclaration anotherDecl) {
        Declaration decl = (Declaration)anotherDecl;
        int anotherDeclLength = decl.getEndLine() - decl.getStartLineWithComments() + 1;
        int thisDeclLength = this.getEndLine() - this.getStartLineWithComments() + 1;
        int offset = decl.getAdjustedLine() - this.getAdjustedLine();
        this.lineAdjustment += anotherDeclLength;
        if (offset > thisDeclLength) {
            this.lineAdjustment += offset - thisDeclLength;
        }
        decl.lineAdjustment -= offset;
    }

    public final int getLineAdjustment() {
        return this.lineAdjustment;
    }

    public int getAdjustedLine() {
        return this.getStartLineWithComments() + this.lineAdjustment;
    }

    public abstract String getElementName();
}

