/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstContinueStatement;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstStatement;
import com.togethersoft.sca.internal.jparser.ast.Ast;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.SimpleName;
import com.togethersoft.sca.internal.jparser.ast.Stmt;
import com.togethersoft.sca.internal.jparser.ast.Visitor;

public class ContinueStmt
extends Stmt
implements AstContinueStatement {
    private JavaToken continueToken;
    private SimpleName label;
    private JavaToken semiToken;
    public Stmt target;

    public ContinueStmt(JavaToken continueToken, SimpleName label, JavaToken semiToken) {
        this.continueToken = continueToken;
        this.label = label;
        this.semiToken = semiToken;
        if (label != null) {
            label.setParent(this);
        }
    }

    public int astType() {
        return 56;
    }

    public int getObjectKind() {
        return 28;
    }

    public AstObject[] getChildren() {
        return Ast.EMPTY_NODE_SET;
    }

    public String getLabelName() {
        return this.label != null ? this.label.getName() : null;
    }

    public AstStatement getContinueTarget() {
        return this.target;
    }

    public SimpleName label() {
        return this.label;
    }

    public void accept(Visitor visitor) {
        if (visitor.stmtVisitor != null) {
            visitor.stmtVisitor.visitContinueStatement(this);
        } else {
            visitor.visitContinueStmt(this);
        }
    }

    public void traverse(Visitor visitor) {
        if (this.label != null) {
            this.label.action(visitor);
        }
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        if (this.label == oldObj) {
            this.label = (SimpleName)newObj;
            return true;
        }
        return false;
    }

    public JavaToken leftToken() {
        return this.continueToken;
    }

    public JavaToken rightToken() {
        return this.semiToken;
    }
}

