/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstConditionalExpression;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.internal.jparser.ast.Expr;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.Visitor;

public class ConditionalExpr
extends Expr
implements AstConditionalExpression {
    Expr testExpression;
    public JavaToken questionToken;
    Expr trueExpression;
    public JavaToken colonToken;
    Expr falseExpression;

    public ConditionalExpr(Expr testExpression, JavaToken questionToken, Expr trueExpression, JavaToken colonToken, Expr falseExpression) {
        this.testExpression = testExpression;
        this.questionToken = questionToken;
        this.trueExpression = trueExpression;
        this.colonToken = colonToken;
        this.falseExpression = falseExpression;
        testExpression.setParent(this);
        trueExpression.setParent(this);
        falseExpression.setParent(this);
    }

    public int astType() {
        return 7;
    }

    public int getObjectKind() {
        return 35;
    }

    public AstExpression[] getOperands() {
        return new AstExpression[]{this.testExpression, this.trueExpression, this.falseExpression};
    }

    public AstExpression testExpression() {
        return this.testExpression;
    }

    public AstExpression trueExpression() {
        return this.trueExpression;
    }

    public AstExpression falseExpression() {
        return this.falseExpression;
    }

    public Expr testExpr() {
        return this.testExpression;
    }

    public Expr trueExpr() {
        return this.trueExpression;
    }

    public Expr falseExpr() {
        return this.falseExpression;
    }

    public void accept(Visitor visitor) {
        if (visitor.exprVisitor != null) {
            visitor.exprVisitor.visitConditionalExpression(this);
        } else {
            visitor.visitConditionalExpr(this);
        }
    }

    public void traverse(Visitor visitor) {
        this.testExpression.action(visitor);
        this.trueExpression.action(visitor);
        this.falseExpression.action(visitor);
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        if (this.testExpression == oldObj) {
            this.testExpression = (Expr)newObj;
        } else if (this.trueExpression == oldObj) {
            this.trueExpression = (Expr)newObj;
        } else if (this.falseExpression == oldObj) {
            this.falseExpression = (Expr)newObj;
        } else {
            return false;
        }
        return true;
    }

    public JavaToken leftToken() {
        return this.testExpression.leftToken();
    }

    public JavaToken rightToken() {
        return this.testExpression.rightToken();
    }
}

