/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstCompilationUnit;
import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstImport;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.internal.jparser.ast.AstVector;
import com.togethersoft.sca.internal.jparser.ast.Declaration;
import com.togethersoft.sca.internal.jparser.ast.ImportDeclaration;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.Name;
import com.togethersoft.sca.internal.jparser.ast.PackageDeclaration;
import com.togethersoft.sca.internal.jparser.ast.TypeDeclaration;
import com.togethersoft.sca.internal.jparser.ast.Visitor;
import com.togethersoft.sca.internal.jparser.ast.writer.AstWriter;
import com.togethersoft.sca.internal.jparser.ast.writer.FormatWriter;
import com.togethersoft.sca.internal.jparser.symbol.CCompilationUnit;
import com.togethersoft.sca.internal.jparser.symbol.CDefinition;
import java.io.OutputStream;

public class CompilationUnit
extends Declaration
implements AstCompilationUnit {
    AstVector importDeclarations;
    AstVector typeDeclarations;
    public JavaToken packageToken;
    private Name pkg;
    public JavaToken semicolon;
    public JavaToken eofToken;
    private String filename;
    private long timestamp;
    private AstType[] types;
    private transient boolean sourcePending = true;
    public CCompilationUnit symbol;

    public CompilationUnit(boolean sourcePending) {
        super(null);
        this.sourcePending = sourcePending;
    }

    public int astType() {
        return 6;
    }

    public CDefinition getSymbol() {
        return this.symbol;
    }

    public boolean sourcePending() {
        return this.sourcePending;
    }

    public void setSourcePending(boolean sourcePending) {
        this.sourcePending = sourcePending;
    }

    public int getObjectKind() {
        return 1;
    }

    public AstObject[] getChildren() {
        int nTypes = this.numTypeDeclarations();
        int nImports = this.numImportDeclarations();
        AstObject[] arr = new AstObject[nTypes + nImports];
        int i = 0;
        while (i < nTypes) {
            arr[i] = this.getTypeDeclaration(i);
            ++i;
        }
        int i2 = 0;
        while (i2 < nImports) {
            arr[i2 + nTypes] = this.getImportDeclaration(i2);
            ++i2;
        }
        return arr;
    }

    public String getElementName() {
        return this.filename;
    }

    public AstType[] getTypes() {
        if (this.types == null) {
            if (this.typeDeclarations == null) {
                this.types = new AstType[0];
            } else {
                this.types = new AstType[this.typeDeclarations.size()];
                this.typeDeclarations.toArray(this.types);
            }
        }
        return this.types;
    }

    public AstImport[] getImports() {
        if (this.importDeclarations == null) {
            return new AstImport[0];
        }
        AstImport[] arrImports = new AstImport[this.importDeclarations.size()];
        this.importDeclarations.toArray(arrImports);
        return arrImports;
    }

    public boolean writeFile(OutputStream s) {
        FormatWriter out = new FormatWriter(s);
        new AstWriter().writeFile(out, this);
        out.close();
        return true;
    }

    public void deepParse() {
        if (this.sourcePending) {
            ((PackageDeclaration)this.getPackage()).getModel().processSource(this);
        }
    }

    AstDeclaration[] getDeclarations() {
        return new AstDeclaration[]{this};
    }

    public String getFilename() {
        return this.filename;
    }

    public void setPackage(Name pkg) {
        this.pkg = pkg;
    }

    public Name getPackageName() {
        return this.pkg;
    }

    public void setFile(String filename, long timestamp) {
        this.filename = filename;
        this.timestamp = timestamp;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int numTypeDeclarations() {
        return this.typeDeclarations == null ? 0 : this.typeDeclarations.size();
    }

    public void addTypeDeclaration(TypeDeclaration type) {
        if (type == null) {
            return;
        }
        if (this.typeDeclarations == null) {
            this.typeDeclarations = new AstVector();
        }
        this.typeDeclarations.add(type);
        type.setParent(this);
    }

    public TypeDeclaration getTypeDeclaration(int i) {
        return (TypeDeclaration)this.typeDeclarations.get(i);
    }

    public TypeDeclaration findType(String name) {
        int i = 0;
        while (i < this.numTypeDeclarations()) {
            if (this.getTypeDeclaration(i).getElementName().equals(name)) {
                return this.getTypeDeclaration(i);
            }
            ++i;
        }
        return null;
    }

    public int numImportDeclarations() {
        return this.importDeclarations == null ? 0 : this.importDeclarations.size();
    }

    public void addImportDeclaration(ImportDeclaration imp) {
        if (this.importDeclarations == null) {
            this.importDeclarations = new AstVector();
        }
        this.importDeclarations.add(imp);
        imp.setParent(this);
    }

    public ImportDeclaration getImportDeclaration(int i) {
        return (ImportDeclaration)this.importDeclarations.get(i);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CompilationUnit) {
            return ((CompilationUnit)obj).filename.equals(this.filename);
        }
        return false;
    }

    public void accept(Visitor visitor) {
        visitor.visitCompilationUnit(this);
    }

    public void traverse(Visitor visitor) {
        if (this.importDeclarations != null) {
            this.importDeclarations.action(visitor);
        }
        if (this.typeDeclarations != null) {
            this.typeDeclarations.action(visitor);
        }
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        return AstVector.replace(this.importDeclarations, oldObj, newObj) || AstVector.replace(this.typeDeclarations, oldObj, newObj);
    }

    public JavaToken leftToken() {
        if (this.packageToken != null) {
            return this.packageToken;
        }
        if (this.numImportDeclarations() > 0) {
            return this.getImportDeclaration(0).leftToken();
        }
        if (this.numTypeDeclarations() > 0) {
            return this.getTypeDeclaration(0).leftToken();
        }
        return this.eofToken;
    }

    public JavaToken rightToken() {
        return this.eofToken;
    }
}

