/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstCompoundStatement;
import com.togethersoft.sca.ast.AstDeclaration;
import com.togethersoft.sca.ast.AstInitializer;
import com.togethersoft.sca.ast.AstMethod;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstTypeReference;
import com.togethersoft.sca.ast.AstVariable;
import com.togethersoft.sca.internal.jparser.ast.Block;
import com.togethersoft.sca.internal.jparser.ast.CompilationUnit;
import com.togethersoft.sca.internal.jparser.ast.Declaration;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.Modifiers;
import com.togethersoft.sca.internal.jparser.ast.PackageDeclaration;
import com.togethersoft.sca.internal.jparser.ast.Visitor;
import com.togethersoft.sca.internal.jparser.symbol.CDefinition;
import com.togethersoft.sca.internal.jparser.symbol.CMethod;

public class ClassInitializer
extends Declaration
implements AstInitializer {
    public JavaToken staticToken;
    transient Block body;
    private boolean hasSource;
    public CMethod symbol;

    public ClassInitializer(Modifiers modifiers, Block body, boolean hasSource) {
        super(modifiers);
        this.body = body;
        this.hasSource = hasSource;
        this.setBody(body);
    }

    public int astType() {
        return 60;
    }

    public CDefinition getSymbol() {
        return this.symbol;
    }

    public int getObjectKind() {
        return 5;
    }

    public AstObject[] getChildren() {
        return new AstObject[]{this.body};
    }

    public String getElementName() {
        return this.symbol.getName();
    }

    public String getQualifiedName() {
        return this.symbol.getQualifiedName();
    }

    public AstTypeReference[] getExceptionTypes() {
        return new AstTypeReference[0];
    }

    public AstVariable[] getParameters() {
        return new AstVariable[0];
    }

    public AstTypeReference getReturnType() {
        return this.symbol.getType();
    }

    public boolean isConstructor() {
        return false;
    }

    public boolean isInitializer() {
        return true;
    }

    public String getSignature() {
        return this.symbol.getSignature();
    }

    public AstCompoundStatement getBody() {
        if (this.hasSource && this.body == null) {
            CompilationUnit cu = (CompilationUnit)this.getDeclaringType().getCompilationUnit();
            ((PackageDeclaration)this.getPackage()).getModel().processSource(cu);
        }
        return this.body;
    }

    public AstMethod[] getOverridden() {
        return new AstMethod[0];
    }

    public AstMethod[] overriddenBy() {
        return new AstMethod[0];
    }

    public boolean isErrorFree() {
        return this.symbol.isErrorFree();
    }

    AstDeclaration[] getDeclarations() {
        return new AstDeclaration[]{this};
    }

    public Block getBlockBody() {
        return this.body;
    }

    void setBody(Block body) {
        this.body = body;
        if (body != null) {
            body.setParent(this);
        }
    }

    public boolean isStatic() {
        return this.staticToken != null;
    }

    public void accept(Visitor visitor) {
        visitor.visitClassInitializer(this);
    }

    public void traverse(Visitor visitor) {
        if ((visitor.getAction() & 4) != 0 && this.body != null) {
            this.body.action(visitor);
        }
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        if (this.body == oldObj) {
            this.body = (Block)newObj;
            return true;
        }
        return false;
    }

    public JavaToken leftToken() {
        return this.staticToken != null ? this.staticToken : this.body.leftToken();
    }

    public JavaToken rightToken() {
        return this.body.rightToken();
    }
}

