/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstCharLiteral;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.Literal;
import com.togethersoft.sca.internal.jparser.symbol.ErrorMgr;

public class CharLiteral
extends Literal
implements AstCharLiteral {
    private char value;

    public CharLiteral(JavaToken literalToken) {
        super(literalToken);
    }

    public CharLiteral(char value) {
        super(null);
        this.value = value;
        this.hasGoodValue = true;
    }

    public int getLiteralKind() {
        return 5;
    }

    public char getValue() {
        return this.value;
    }

    public boolean eval() {
        if (this.hasGoodValue) {
            return true;
        }
        String source = this.literalToken.getText();
        this.value = '\u0000';
        this.value = source.charAt(1);
        if (this.value != '\\') {
            this.hasGoodValue = true;
            return true;
        }
        char c = source.charAt(2);
        switch (c) {
            case 'b': {
                this.value = (char)8;
                break;
            }
            case 't': {
                this.value = (char)9;
                break;
            }
            case 'n': {
                this.value = (char)10;
                break;
            }
            case 'f': {
                this.value = (char)12;
                break;
            }
            case 'r': {
                this.value = (char)13;
                break;
            }
            case '\"': {
                this.value = (char)34;
                break;
            }
            case '\'': {
                this.value = (char)39;
                break;
            }
            case '\\': {
                this.value = (char)92;
                break;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                int number = Character.getNumericValue(c);
                c = source.charAt(3);
                if (c != '\'') {
                    number = number * 8 + Character.getNumericValue(c);
                    c = source.charAt(4);
                    if (this.value != '\'') {
                        number = number * 8 + Character.getNumericValue(c);
                    }
                }
                this.value = (char)number;
                break;
            }
            default: {
                ErrorMgr.report(34, this.literalToken, this.literalToken, this.literalToken.getText());
                this.hasGoodValue = false;
                return false;
            }
        }
        this.hasGoodValue = true;
        return true;
    }
}

