/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstCatchClause;
import com.togethersoft.sca.ast.AstCompoundStatement;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstVariable;
import com.togethersoft.sca.internal.jparser.ast.Block;
import com.togethersoft.sca.internal.jparser.ast.FormalParameter;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.Stmt;
import com.togethersoft.sca.internal.jparser.ast.Visitor;

public class CatchClause
extends Stmt
implements AstCatchClause {
    private JavaToken catchToken;
    public JavaToken leftParen;
    private FormalParameter param;
    public JavaToken rightParen;
    private Block body;

    public CatchClause(JavaToken catchToken, JavaToken leftParen, FormalParameter param, JavaToken rightParen, Block body) {
        this.catchToken = catchToken;
        this.leftParen = leftParen;
        this.param = param;
        this.rightParen = rightParen;
        this.body = body;
        param.setParent(this);
        body.setParent(this);
    }

    public int astType() {
        return 48;
    }

    public int getObjectKind() {
        return 20;
    }

    public AstObject[] getChildren() {
        return new AstObject[]{this.param, this.body};
    }

    public AstVariable getParameter() {
        return this.param.declarator;
    }

    public AstCompoundStatement getBody() {
        return this.body;
    }

    public FormalParameter param() {
        return this.param;
    }

    public Block body() {
        return this.body;
    }

    public void accept(Visitor visitor) {
        visitor.visitCatchClause(this);
    }

    public void traverse(Visitor visitor) {
        this.param.action(visitor);
        this.body.action(visitor);
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        if (this.param == oldObj) {
            this.param = (FormalParameter)newObj;
        } else if (this.body == newObj) {
            this.body = (Block)newObj;
        } else {
            return false;
        }
        return true;
    }

    public JavaToken leftToken() {
        return this.catchToken;
    }

    public JavaToken rightToken() {
        return this.body.rightToken();
    }
}

