/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.jparser.ast;

import com.togethersoft.sca.ast.AstCastExpression;
import com.togethersoft.sca.ast.AstExpression;
import com.togethersoft.sca.ast.AstObject;
import com.togethersoft.sca.ast.AstTypeExpression;
import com.togethersoft.sca.ast.AstTypeReference;
import com.togethersoft.sca.internal.jparser.ast.Expr;
import com.togethersoft.sca.internal.jparser.ast.JavaToken;
import com.togethersoft.sca.internal.jparser.ast.TypeExpr;
import com.togethersoft.sca.internal.jparser.ast.Visitor;

public class CastExpr
extends Expr
implements AstCastExpression {
    public JavaToken leftParen;
    public TypeExpr typeSpec;
    public JavaToken rightParen;
    public Expr expression;

    public CastExpr(JavaToken leftParen, TypeExpr typeSpec, JavaToken rightParen, Expr expression) {
        this.leftParen = leftParen;
        this.typeSpec = typeSpec;
        this.rightParen = rightParen;
        this.expression = expression;
        typeSpec.setParent(this);
        expression.setParent(this);
    }

    public int astType() {
        return 4;
    }

    public int getObjectKind() {
        return 34;
    }

    public AstExpression[] getOperands() {
        return new AstExpression[]{this.typeSpec, this.expression};
    }

    public AstTypeReference getCastType() {
        return this.typeSpec.getType();
    }

    public AstTypeExpression getCastExpression() {
        return this.typeSpec;
    }

    public AstExpression getExpression() {
        return this.expression;
    }

    public void accept(Visitor visitor) {
        if (visitor.exprVisitor != null) {
            visitor.exprVisitor.visitCastExpression(this);
        } else {
            visitor.visitCastExpr(this);
        }
    }

    public void traverse(Visitor visitor) {
        this.typeSpec.action(visitor);
        this.expression.action(visitor);
    }

    boolean replace(AstObject oldObj, AstObject newObj) {
        if (this.typeSpec == oldObj) {
            this.typeSpec = (TypeExpr)newObj;
        } else if (this.expression == oldObj) {
            this.expression = (Expr)newObj;
        } else {
            return false;
        }
        return true;
    }

    public JavaToken leftToken() {
        return this.leftParen;
    }

    public JavaToken rightToken() {
        return this.expression.rightToken();
    }
}

